/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.type;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import kd.bos.algox.RowX;
import kd.bos.algox.flink.type.NullMaskUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeComparator;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.typeutils.runtime.NullAwareComparator;
import org.apache.flink.api.java.typeutils.runtime.TupleComparatorBase;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.KeyFieldOutOfBoundsException;
import org.apache.flink.util.Preconditions;

@Internal
public class RowXComparator
extends CompositeTypeComparator<RowX> {
    private static final long serialVersionUID = 1L;
    private final int arity;
    private final int[] keyPositions;
    private final NullAwareComparator<Object>[] comparators;
    private final TypeSerializer<Object>[] serializers;
    private final int[] normalizedKeyLengths;
    private final int numLeadingNormalizableKeys;
    private final int normalizableKeyPrefixLen;
    private final boolean invertNormKey;
    private final boolean[] nullMask1;
    private final boolean[] nullMask2;
    private final transient Object[] deserializedKeyFields1;
    private final transient Object[] deserializedKeyFields2;

    public RowXComparator(int arity, int[] keyPositions, TypeComparator<Object>[] comparators, TypeSerializer<Object>[] serializers, boolean[] orders) {
        this(arity, keyPositions, RowXComparator.makeNullAware(comparators, orders), serializers);
    }

    private RowXComparator(int arity, int[] keyPositions, NullAwareComparator<Object>[] comparators, TypeSerializer<Object>[] serializers) {
        this(arity, keyPositions, comparators, serializers, RowXComparator.createAuxiliaryFields(keyPositions, comparators));
    }

    private RowXComparator(int arity, int[] keyPositions, NullAwareComparator<Object>[] comparators, TypeSerializer<Object>[] serializers, Tuple4<int[], Integer, Integer, Boolean> auxiliaryFields) {
        this(arity, keyPositions, comparators, serializers, (int[])auxiliaryFields.f0, (Integer)auxiliaryFields.f1, (Integer)auxiliaryFields.f2, (Boolean)auxiliaryFields.f3);
    }

    private RowXComparator(int arity, int[] keyPositions, NullAwareComparator<Object>[] comparators, TypeSerializer<Object>[] serializers, int[] normalizedKeyLengths, int numLeadingNormalizableKeys, int normalizableKeyPrefixLen, boolean invertNormKey) {
        this.arity = arity;
        this.keyPositions = keyPositions;
        this.comparators = comparators;
        this.serializers = serializers;
        this.normalizedKeyLengths = normalizedKeyLengths;
        this.numLeadingNormalizableKeys = numLeadingNormalizableKeys;
        this.normalizableKeyPrefixLen = normalizableKeyPrefixLen;
        this.invertNormKey = invertNormKey;
        this.nullMask1 = new boolean[arity];
        this.nullMask2 = new boolean[arity];
        this.deserializedKeyFields1 = this.instantiateDeserializationFields();
        this.deserializedKeyFields2 = this.instantiateDeserializationFields();
    }

    public void getFlatComparator(List<TypeComparator> flatComparators) {
        for (NullAwareComparator<Object> c : this.comparators) {
            Collections.addAll(flatComparators, c.getFlatComparators());
        }
    }

    public int hash(RowX record) {
        int i;
        int code = 0;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                code *= TupleComparatorBase.HASH_SALT[i & 0x1F];
                Object element = record.get(this.keyPositions[i]);
                code += this.comparators[i].hash(element);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
        return code;
    }

    public void setReference(RowX toCompare) {
        int i;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                NullAwareComparator<Object> comparator = this.comparators[i];
                Object element = toCompare.get(this.keyPositions[i]);
                comparator.setReference(element);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
    }

    public boolean equalToReference(RowX candidate) {
        int i;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                NullAwareComparator<Object> comparator = this.comparators[i];
                Object element = candidate.get(this.keyPositions[i]);
                if (comparator.equalToReference(element)) continue;
                return false;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
        return true;
    }

    public int compareToReference(TypeComparator<RowX> referencedComparator) {
        int i;
        RowXComparator other = (RowXComparator)referencedComparator;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                int cmp = this.comparators[i].compareToReference(other.comparators[i]);
                if (cmp == 0) continue;
                return cmp;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
        return 0;
    }

    public int compare(RowX first, RowX second) {
        int i;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                Object secondElement;
                NullAwareComparator<Object> comparator = this.comparators[i];
                int keyPos = this.keyPositions[i];
                Object firstElement = first.get(keyPos);
                int cmp = comparator.compare(firstElement, secondElement = second.get(keyPos));
                if (cmp == 0) continue;
                return cmp;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
        return 0;
    }

    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int i;
        int len = this.serializers.length;
        int keyLen = this.keyPositions.length;
        NullMaskUtils.readIntoNullMask(this.arity, firstSource, this.nullMask1);
        NullMaskUtils.readIntoNullMask(this.arity, secondSource, this.nullMask2);
        for (i = 0; i < len; ++i) {
            TypeSerializer<Object> serializer = this.serializers[i];
            if (!this.nullMask1[i]) {
                this.deserializedKeyFields1[i] = serializer.deserialize(this.deserializedKeyFields1[i], firstSource);
            }
            if (this.nullMask2[i]) continue;
            this.deserializedKeyFields2[i] = serializer.deserialize(this.deserializedKeyFields2[i], secondSource);
        }
        for (i = 0; i < keyLen; ++i) {
            int keyPos = this.keyPositions[i];
            NullAwareComparator<Object> comparator = this.comparators[i];
            boolean isNull1 = this.nullMask1[keyPos];
            boolean isNull2 = this.nullMask2[keyPos];
            int cmp = 0;
            cmp = isNull1 && isNull2 ? 0 : (isNull1 ? comparator.compare(null, this.deserializedKeyFields2[keyPos]) : (isNull2 ? comparator.compare(this.deserializedKeyFields1[keyPos], null) : comparator.compare(this.deserializedKeyFields1[keyPos], this.deserializedKeyFields2[keyPos])));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public boolean supportsNormalizedKey() {
        return this.numLeadingNormalizableKeys > 0;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public int getNormalizeKeyLen() {
        return this.normalizableKeyPrefixLen;
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return this.numLeadingNormalizableKeys < this.keyPositions.length || this.normalizableKeyPrefixLen == Integer.MAX_VALUE || this.normalizableKeyPrefixLen > keyBytes;
    }

    public void putNormalizedKey(RowX record, MemorySegment target, int offset, int numBytes) {
        int bytesLeft = numBytes;
        int currentOffset = offset;
        for (int i = 0; i < this.numLeadingNormalizableKeys && bytesLeft > 0; ++i) {
            int len = this.normalizedKeyLengths[i];
            len = bytesLeft >= len ? len : bytesLeft;
            NullAwareComparator<Object> comparator = this.comparators[i];
            Object element = record.get(this.keyPositions[i]);
            comparator.putNormalizedKey(element, target, currentOffset, len);
            bytesLeft -= len;
            currentOffset += len;
        }
    }

    public void writeWithKeyNormalization(RowX record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException("Record serialization with leading normalized keys not supported.");
    }

    public RowX readWithKeyDenormalization(RowX reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException("Record deserialization with leading normalized keys not supported.");
    }

    public boolean invertNormalizedKey() {
        return this.invertNormKey;
    }

    public TypeComparator<RowX> duplicate() {
        NullAwareComparator[] comparatorsCopy = new NullAwareComparator[this.comparators.length];
        for (int i = 0; i < this.comparators.length; ++i) {
            comparatorsCopy[i] = (NullAwareComparator)this.comparators[i].duplicate();
        }
        TypeSerializer[] serializersCopy = new TypeSerializer[this.serializers.length];
        for (int i = 0; i < this.serializers.length; ++i) {
            serializersCopy[i] = this.serializers[i].duplicate();
        }
        return new RowXComparator(this.arity, this.keyPositions, comparatorsCopy, serializersCopy, this.normalizedKeyLengths, this.numLeadingNormalizableKeys, this.normalizableKeyPrefixLen, this.invertNormKey);
    }

    public int extractKeys(Object record, Object[] target, int index) {
        int len = this.comparators.length;
        int localIndex = index;
        for (int i = 0; i < len; ++i) {
            Object element = ((RowX)record).get(this.keyPositions[i]);
            localIndex += this.comparators[i].extractKeys(element, target, localIndex);
        }
        return localIndex - index;
    }

    private Object[] instantiateDeserializationFields() {
        Object[] newFields = new Object[this.serializers.length];
        for (int i = 0; i < this.serializers.length; ++i) {
            newFields[i] = this.serializers[i].createInstance();
        }
        return newFields;
    }

    private static Tuple4<int[], Integer, Integer, Boolean> createAuxiliaryFields(int[] keyPositions, NullAwareComparator<Object>[] comparators) {
        int[] normalizedKeyLengths = new int[keyPositions.length];
        int numLeadingNormalizableKeys = 0;
        int normalizableKeyPrefixLen = 0;
        boolean inverted = false;
        for (int i = 0; i < keyPositions.length; ++i) {
            NullAwareComparator<Object> k = comparators[i];
            if (k.supportsNormalizedKey()) {
                if (i == 0) {
                    inverted = k.invertNormalizedKey();
                } else if (k.invertNormalizedKey() != inverted) {
                    return new Tuple4((Object)normalizedKeyLengths, (Object)numLeadingNormalizableKeys, (Object)normalizableKeyPrefixLen, (Object)inverted);
                }
                ++numLeadingNormalizableKeys;
                int len = k.getNormalizeKeyLen();
                if (len < 0) {
                    throw new RuntimeException("Comparator " + k.getClass().getName() + " specifies an invalid length for the normalized key: " + len);
                }
                normalizedKeyLengths[i] = len;
                if ((normalizableKeyPrefixLen += len) >= 0) continue;
                return new Tuple4((Object)normalizedKeyLengths, (Object)numLeadingNormalizableKeys, (Object)Integer.MAX_VALUE, (Object)inverted);
            }
            return new Tuple4((Object)normalizedKeyLengths, (Object)numLeadingNormalizableKeys, (Object)normalizableKeyPrefixLen, (Object)inverted);
        }
        return new Tuple4((Object)normalizedKeyLengths, (Object)numLeadingNormalizableKeys, (Object)normalizableKeyPrefixLen, (Object)inverted);
    }

    private static NullAwareComparator<Object>[] makeNullAware(TypeComparator<Object>[] comparators, boolean[] orders) {
        Preconditions.checkArgument((comparators.length == orders.length ? 1 : 0) != 0);
        NullAwareComparator[] result = new NullAwareComparator[comparators.length];
        for (int i = 0; i < comparators.length; ++i) {
            result[i] = new NullAwareComparator(comparators[i], orders[i]);
        }
        return result;
    }
}

