/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.utils;

import kd.bos.util.ConfigurationUtil;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;

public class AkkaProtocolUtil {
    public static final String ARTERY_PROTOCOL_PREFIX = "akka";

    private AkkaProtocolUtil() {
    }

    public static boolean isArtery() {
        String type = System.getProperty("algox.akka.type");
        if (type == null) {
            type = "old";
        }
        switch (type = type.toLowerCase()) {
            default: {
                return false;
            }
            case "new": 
        }
        return AkkaProtocolUtil.autoGetArteryType();
    }

    private static boolean autoGetArteryType() {
        try {
            Class.forName("org.jboss.netty.bootstrap.Bootstrap");
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static void setAkkaProtocol(Configuration configuration) {
        configuration.setBoolean("akka.artery", AkkaProtocolUtil.isArtery());
    }

    public static void setAkkaFrameSize(Configuration configuration, boolean local) {
        String bufferPoolSize;
        String frameSize = ConfigurationUtil.getString((String)"algox.akka.framesize", (String)"20");
        if (local) {
            frameSize = ConfigurationUtil.getString((String)"algox.local.akka.framesize", (String)"10");
        }
        if (frameSize != null) {
            try {
                configuration.setString((ConfigOption<String>)AkkaOptions.FRAMESIZE, "" + 0x100000L * (long)Integer.parseInt(frameSize) + "b");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((bufferPoolSize = ConfigurationUtil.getString((String)"algox.akka.bufferPoolSize", (String)"32")) != null) {
            try {
                configuration.setString("akkaBufferPoolSize", String.valueOf(Integer.parseInt(bufferPoolSize)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

