/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.algo.output.IgnoreOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.context.RequestContextCreator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;

public class RemoteDemoStart
implements Serializable {
    private static final long serialVersionUID = 4212347243461609505L;
    private static Log log = LogFactory.getLog(RemoteDemoStart.class);

    public static void start() {
        RemoteDemoStart.start(60, "Remote Demo");
    }

    public static boolean test() {
        return RemoteDemoStart.start(30, "Cluster test");
    }

    public static boolean start(int timeout, String desc) {
        String region = ConfigurationUtil.getString((String)"algox.cluster.region", (String)"default");
        JobSession session = AlgoX.createSession((String)(desc + " of " + region));
        session.getContext().setRegion(region);
        RowMeta rowMeta = new RowMeta(new String[]{"name"}, new DataType[]{DataType.StringType});
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (int i = 0; i < 10; ++i) {
            Object[] row = new Object[]{"" + System.currentTimeMillis() % 10000L};
            data.add(row);
        }
        CollectionInput input = new CollectionInput(rowMeta, data);
        DataSetX dataSet = session.fromInput((Input)input);
        dataSet = dataSet.orderBy(new String[]{"name"});
        dataSet.output((Output)new IgnoreOutput());
        RequestContextCreator.createForPreheat((String)"0", (String)"0");
        try {
            session.commit(timeout, TimeUnit.SECONDS);
            return true;
        }
        catch (Throwable t) {
            log.error(t);
            return false;
        }
    }
}

