/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.ArrayList;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.SchedulerExecutionMode;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.LinkElement;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class ClusterOptions {
    @Documentation.Section(value={"expert_fault_tolerance"})
    public static final ConfigOption<Long> INITIAL_REGISTRATION_TIMEOUT = ConfigOptions.key((String)"cluster.registration.initial-timeout").defaultValue((Object)100L).withDescription("Initial registration timeout between cluster components in milliseconds.");
    @Documentation.Section(value={"expert_fault_tolerance"})
    public static final ConfigOption<Long> MAX_REGISTRATION_TIMEOUT = ConfigOptions.key((String)"cluster.registration.max-timeout").defaultValue((Object)30000L).withDescription("Maximum registration timeout between cluster components in milliseconds.");
    @Documentation.Section(value={"expert_fault_tolerance"})
    public static final ConfigOption<Long> ERROR_REGISTRATION_DELAY = ConfigOptions.key((String)"cluster.registration.error-delay").defaultValue((Object)10000L).withDescription("The pause made after an registration attempt caused an exception (other than timeout) in milliseconds.");
    @Documentation.Section(value={"expert_fault_tolerance"})
    public static final ConfigOption<Long> REFUSED_REGISTRATION_DELAY = ConfigOptions.key((String)"cluster.registration.refused-registration-delay").defaultValue((Object)30000L).withDescription("The pause made after the registration attempt was refused in milliseconds.");
    @Documentation.Section(value={"expert_fault_tolerance"})
    public static final ConfigOption<Long> CLUSTER_SERVICES_SHUTDOWN_TIMEOUT = ConfigOptions.key((String)"cluster.services.shutdown-timeout").defaultValue((Object)30000L).withDescription("The shutdown timeout for cluster services like executors in milliseconds.");
    @Documentation.Section(value={"expert_fault_tolerance"})
    public static final ConfigOption<Integer> CLUSTER_IO_EXECUTOR_POOL_SIZE = ConfigOptions.key((String)"cluster.io-pool.size").intType().noDefaultValue().withDescription("The size of the IO executor pool used by the cluster to execute blocking IO operations (Master as well as TaskManager processes). By default it will use 4 * the number of CPU cores (hardware contexts) that the cluster process has access to. Increasing the pool size allows to run more IO operations concurrently.");
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Boolean> EVENLY_SPREAD_OUT_SLOTS_STRATEGY = ConfigOptions.key((String)"cluster.evenly-spread-out-slots").defaultValue((Object)false).withDescription(Description.builder().text("Enable the slot spread out allocation strategy. This strategy tries to spread out the slots evenly across all available %s.", new InlineElement[]{TextElement.code((String)"TaskExecutors")}).build());
    @Documentation.Section(value={"expert_cluster"})
    public static final ConfigOption<Boolean> HALT_ON_FATAL_ERROR = ConfigOptions.key((String)"cluster.processes.halt-on-fatal-error").booleanType().defaultValue((Object)false).withDescription(Description.builder().text("Whether processes should halt on fatal errors instead of performing a graceful shutdown. In some environments (e.g. Java 8 with the G1 garbage collector), a regular graceful shutdown can lead to a JVM deadlock. See %s for details.", new InlineElement[]{LinkElement.link((String)"https://issues.apache.org/jira/browse/FLINK-16510", (String)"FLINK-16510")}).build());
    @Documentation.Section(value={"expert_cluster"})
    public static final ConfigOption<UserSystemExitMode> INTERCEPT_USER_SYSTEM_EXIT = ConfigOptions.key((String)"cluster.intercept-user-system-exit").enumType(UserSystemExitMode.class).defaultValue((Object)UserSystemExitMode.DISABLED).withDescription(UserSystemExitMode.getConfigDescription());
    @Documentation.ExcludeFromDocumentation
    public static final ConfigOption<Boolean> ENABLE_DECLARATIVE_RESOURCE_MANAGEMENT = ConfigOptions.key((String)"cluster.declarative-resource-management.enabled").booleanType().defaultValue((Object)true).withDescription("Defines whether the cluster uses declarative resource management.");
    @Documentation.ExcludeFromDocumentation
    public static final ConfigOption<Boolean> ENABLE_FINE_GRAINED_RESOURCE_MANAGEMENT = ConfigOptions.key((String)"cluster.fine-grained-resource-management.enabled").booleanType().defaultValue((Object)false).withDescription("Defines whether the cluster uses fine-grained resource management.");

    public static boolean isDeclarativeResourceManagementEnabled(Configuration configuration) {
        if (configuration.contains(ENABLE_DECLARATIVE_RESOURCE_MANAGEMENT)) {
            return configuration.get(ENABLE_DECLARATIVE_RESOURCE_MANAGEMENT);
        }
        return !System.getProperties().containsKey("flink.tests.disable-declarative");
    }

    public static JobManagerOptions.SchedulerType getSchedulerType(Configuration configuration) {
        if (ClusterOptions.isAdaptiveSchedulerEnabled(configuration) || ClusterOptions.isReactiveModeEnabled(configuration)) {
            return JobManagerOptions.SchedulerType.Adaptive;
        }
        return (JobManagerOptions.SchedulerType)configuration.get(JobManagerOptions.SCHEDULER);
    }

    private static boolean isReactiveModeEnabled(Configuration configuration) {
        return configuration.get(JobManagerOptions.SCHEDULER_MODE) == SchedulerExecutionMode.REACTIVE;
    }

    public static boolean isAdaptiveSchedulerEnabled(Configuration configuration) {
        if (configuration.contains(JobManagerOptions.SCHEDULER)) {
            return configuration.get(JobManagerOptions.SCHEDULER) == JobManagerOptions.SchedulerType.Adaptive;
        }
        return System.getProperties().containsKey("flink.tests.enable-adaptive-scheduler");
    }

    public static boolean isFineGrainedResourceManagementEnabled(Configuration configuration) {
        if (!ClusterOptions.isDeclarativeResourceManagementEnabled(configuration)) {
            return false;
        }
        if (configuration.contains(ENABLE_FINE_GRAINED_RESOURCE_MANAGEMENT)) {
            return configuration.get(ENABLE_FINE_GRAINED_RESOURCE_MANAGEMENT);
        }
        return System.getProperties().containsKey("flink.tests.enable-fine-grained");
    }

    public static enum UserSystemExitMode {
        DISABLED("Flink is not monitoring or intercepting calls to System.exit()"),
        LOG("Log exit attempt with stack trace but still allowing exit to be performed"),
        THROW("Throw exception when exit is attempted disallowing JVM termination");

        private final String description;

        private UserSystemExitMode(String description) {
            this.description = description;
        }

        public static Description getConfigDescription() {
            Description.DescriptionBuilder builder = Description.builder();
            ArrayList<TextElement> modeDescriptions = new ArrayList<TextElement>(UserSystemExitMode.values().length);
            builder.text("Flag to check user code exiting system by terminating JVM (e.g., System.exit())");
            for (UserSystemExitMode mode : UserSystemExitMode.values()) {
                modeDescriptions.add(TextElement.text((String)String.format("%s - %s", mode.name(), mode.getDescription())));
            }
            builder.list((InlineElement[])modeDescriptions.toArray(new TextElement[modeDescriptions.size()]));
            builder.linebreak();
            builder.text("Note that this configuration option can interfere with %s: In intercepted user-code, a call to System.exit() will not cause the JVM to halt, when %s is configured.", new InlineElement[]{TextElement.code((String)HALT_ON_FATAL_ERROR.key()), TextElement.code((String)THROW.name())});
            return builder.build();
        }

        public String getDescription() {
            return this.description;
        }
    }
}

