/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.heartbeat;

import java.util.concurrent.TimeUnit;
import kd.bos.algox.flink.cluster.local.LocalMasterRuntimeContext;
import kd.bos.algox.flink.cluster.masterworker.MasterRuntimeContext;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.heartbeat.HeartbeatListener;
import org.apache.flink.runtime.heartbeat.HeartbeatManagerImpl;
import org.apache.flink.runtime.heartbeat.HeartbeatMonitor;
import org.apache.flink.runtime.heartbeat.HeartbeatMonitorImpl;
import org.apache.flink.runtime.heartbeat.HeartbeatTarget;
import org.slf4j.Logger;

public class HeartbeatManagerSenderImpl<I, O>
extends HeartbeatManagerImpl<I, O>
implements Runnable {
    private final long heartbeatPeriod;

    HeartbeatManagerSenderImpl(long heartbeatPeriod, long heartbeatTimeout, ResourceID ownResourceID, HeartbeatListener<I, O> heartbeatListener, ScheduledExecutor mainThreadExecutor, Logger log) {
        this(heartbeatPeriod, heartbeatTimeout, ownResourceID, heartbeatListener, mainThreadExecutor, log, (HeartbeatMonitor.Factory<O>)new HeartbeatMonitorImpl.Factory());
    }

    HeartbeatManagerSenderImpl(long heartbeatPeriod, long heartbeatTimeout, ResourceID ownResourceID, HeartbeatListener<I, O> heartbeatListener, ScheduledExecutor mainThreadExecutor, Logger log, HeartbeatMonitor.Factory<O> heartbeatMonitorFactory) {
        super(heartbeatTimeout, ownResourceID, heartbeatListener, mainThreadExecutor, log, heartbeatMonitorFactory);
        this.heartbeatPeriod = heartbeatPeriod;
        mainThreadExecutor.schedule((Runnable)this, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        if (!this.stopped) {
            this.log.debug("Trigger heartbeat request.");
            for (HeartbeatMonitor heartbeatMonitor : this.getHeartbeatTargets().values()) {
                this.requestHeartbeat(heartbeatMonitor);
            }
            this.getMainThreadExecutor().schedule((Runnable)this, this.heartbeatPeriod, TimeUnit.MILLISECONDS);
        }
    }

    private void requestHeartbeat(final HeartbeatMonitor<O> heartbeatMonitor) {
        if (MasterRuntimeContext.isEnable() || LocalMasterRuntimeContext.isEnable()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Object payload = HeartbeatManagerSenderImpl.this.getHeartbeatListener().retrievePayload(heartbeatMonitor.getHeartbeatTargetId());
                    HeartbeatTarget heartbeatTarget = heartbeatMonitor.getHeartbeatTarget();
                    heartbeatTarget.requestHeartbeat(HeartbeatManagerSenderImpl.this.getOwnResourceID(), payload);
                }
            }, "HeartbeatToWorker").start();
        }
    }
}

