/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.handler.FileUploads;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger LOG = LoggerFactory.getLogger(FileUploadHandler.class);
    public static final String HTTP_ATTRIBUTE_REQUEST = "request";
    private static final AttributeKey<FileUploads> UPLOADED_FILES = AttributeKey.valueOf((String)"UPLOADED_FILES");
    private static final HttpDataFactory DATA_FACTORY = new DefaultHttpDataFactory(true);
    private final Path uploadDir;
    private HttpPostRequestDecoder currentHttpPostRequestDecoder;
    private HttpRequest currentHttpRequest;
    private byte[] currentJsonPayload;
    private Path currentUploadDir;

    public FileUploadHandler(Path uploadDir) {
        super(true);
        DiskAttribute.deleteOnExitTemporaryFile = false;
        DiskFileUpload.deleteOnExitTemporaryFile = false;
        DiskAttribute.baseDirectory = DiskFileUpload.baseDirectory = uploadDir.normalize().toAbsolutePath().toString();
        this.uploadDir = Objects.requireNonNull(uploadDir);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        try {
            if (msg instanceof HttpRequest) {
                HttpRequest httpRequest = (HttpRequest)msg;
                LOG.trace("Received request. URL:{} Method:{}", (Object)httpRequest.getUri(), (Object)httpRequest.getMethod());
                if (httpRequest.getMethod().equals((Object)HttpMethod.POST)) {
                    if (HttpPostRequestDecoder.isMultipart((HttpRequest)httpRequest)) {
                        LOG.trace("Initializing multipart file upload.");
                        Preconditions.checkState((this.currentHttpPostRequestDecoder == null ? 1 : 0) != 0);
                        Preconditions.checkState((this.currentHttpRequest == null ? 1 : 0) != 0);
                        Preconditions.checkState((this.currentUploadDir == null ? 1 : 0) != 0);
                        this.currentHttpPostRequestDecoder = new HttpPostRequestDecoder(DATA_FACTORY, httpRequest);
                        this.currentHttpRequest = (HttpRequest)ReferenceCountUtil.retain((Object)httpRequest);
                        throw new UnsupportedOperationException("Not allowed for safety.");
                    }
                    ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
                } else {
                    ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
                }
            } else {
                if (msg instanceof HttpContent && this.currentHttpPostRequestDecoder != null) {
                    throw new UnsupportedOperationException("Not allowed for safety.");
                }
                ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
            }
        }
        catch (Exception e) {
            this.handleError(ctx, "File upload failed.", HttpResponseStatus.INTERNAL_SERVER_ERROR, e);
        }
    }

    private void handleError(ChannelHandlerContext ctx, String errorMessage, HttpResponseStatus responseStatus, @Nullable Throwable e) {
        HttpRequest tmpRequest = this.currentHttpRequest;
        this.deleteUploadedFiles();
        this.reset();
        LOG.warn(errorMessage, e);
        HandlerUtils.sendErrorResponse((ChannelHandlerContext)ctx, (HttpRequest)tmpRequest, (ErrorResponseBody)new ErrorResponseBody(errorMessage), (HttpResponseStatus)responseStatus, Collections.emptyMap());
        ReferenceCountUtil.release((Object)tmpRequest);
    }

    private void deleteUploadedFiles() {
        if (this.currentUploadDir != null) {
            try {
                FileUtils.deleteDirectory((File)this.currentUploadDir.toFile());
            }
            catch (IOException e) {
                LOG.warn("Could not cleanup uploaded files.", (Throwable)e);
            }
        }
    }

    private void reset() {
        try {
            this.currentHttpPostRequestDecoder.getBodyHttpDatas().clear();
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException ned) {
            LOG.debug("Error while resetting handler.", (Throwable)ned);
        }
        this.currentHttpPostRequestDecoder.destroy();
        this.currentHttpPostRequestDecoder = null;
        this.currentHttpRequest = null;
        this.currentUploadDir = null;
        this.currentJsonPayload = null;
    }

    public static FileUploads getMultipartFileUploads(ChannelHandlerContext ctx) {
        return (FileUploads)Optional.ofNullable(ctx.channel().attr(UPLOADED_FILES).getAndRemove()).orElse(FileUploads.EMPTY);
    }
}

