/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.InstantiationUtil;

public class SerializedThrowable
extends Exception
implements Serializable {
    private static final long serialVersionUID = 7284183123441947635L;
    private byte[] serializedException;
    private String originalErrorClassName;
    private String fullStringifiedStackTrace;
    private transient WeakReference<Throwable> cachedException;

    public SerializedThrowable() {
    }

    public SerializedThrowable(Throwable exception) {
        this(exception, new HashSet<Throwable>());
    }

    private SerializedThrowable(Throwable exception, Set<Throwable> alreadySeen) {
        super(SerializedThrowable.getMessageOrError(exception));
        if (!(exception instanceof SerializedThrowable)) {
            byte[] serialized;
            try {
                serialized = InstantiationUtil.serializeObject((Object)exception);
            }
            catch (Throwable t) {
                serialized = null;
            }
            this.serializedException = serialized;
            this.cachedException = new WeakReference<Throwable>(exception);
            this.originalErrorClassName = exception.getClass().getName();
            this.fullStringifiedStackTrace = ExceptionUtils.stringifyException((Throwable)exception);
            this.setStackTrace(exception.getStackTrace());
            if (exception.getCause() == null) {
                this.initCause(null);
            } else if (alreadySeen.add(exception)) {
                this.initCause(new SerializedThrowable(exception.getCause(), alreadySeen));
            }
        } else {
            SerializedThrowable other = (SerializedThrowable)exception;
            this.serializedException = other.serializedException;
            this.originalErrorClassName = other.originalErrorClassName;
            this.fullStringifiedStackTrace = other.fullStringifiedStackTrace;
            this.cachedException = other.cachedException;
            this.setStackTrace(other.getStackTrace());
            this.initCause(other.getCause());
        }
    }

    @Override
    public synchronized Throwable getCause() {
        Throwable throwable = this.deserializeError(this.getClass().getClassLoader());
        if (throwable == this) {
            return super.getCause();
        }
        return throwable;
    }

    public Throwable deserializeError(ClassLoader classloader) {
        Throwable cached;
        if (this.serializedException == null) {
            return this;
        }
        Throwable throwable = cached = this.cachedException == null ? null : (Throwable)this.cachedException.get();
        if (cached == null) {
            try {
                cached = (Throwable)InstantiationUtil.deserializeObject((byte[])this.serializedException, (ClassLoader)classloader);
                this.cachedException = new WeakReference<Throwable>(cached);
            }
            catch (Throwable t) {
                return this;
            }
        }
        return cached;
    }

    public String getOriginalErrorClassName() {
        return this.originalErrorClassName;
    }

    public byte[] getSerializedException() {
        return this.serializedException;
    }

    public String getFullStringifiedStackTrace() {
        return this.fullStringifiedStackTrace;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        s.print(this.fullStringifiedStackTrace);
        s.flush();
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        s.print(this.fullStringifiedStackTrace);
        s.flush();
    }

    @Override
    public String toString() {
        String message = this.getLocalizedMessage();
        return message != null ? this.originalErrorClassName + ": " + message : this.originalErrorClassName;
    }

    public static Throwable get(Throwable serThrowable, ClassLoader loader) {
        if (serThrowable instanceof SerializedThrowable) {
            return ((SerializedThrowable)serThrowable).deserializeError(loader);
        }
        return serThrowable;
    }

    private static String getMessageOrError(Throwable error) {
        try {
            return error.getMessage();
        }
        catch (Throwable t) {
            return "(failed to get message)";
        }
    }
}

