/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.audit;

import java.lang.reflect.Method;
import kd.bos.audit.AuditLogContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultAuditLogContext
implements AuditLogContext {
    private static Logger logger = LoggerFactory.getLogger(DefaultAuditLogContext.class);
    private static Method getRequestContext;
    private static Method mGetTraceId;
    private static Method getAccountId;
    private static Method getAccountById;
    private static Method mGetAccountName;
    private static Method mGetVersion;

    DefaultAuditLogContext() {
    }

    @Override
    public String getTraceId() {
        try {
            return (String)mGetTraceId.invoke(getRequestContext.invoke(null, new Object[0]), new Object[0]);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getAccountName() {
        try {
            String accountId = (String)getAccountId.invoke(getRequestContext.invoke(null, new Object[0]), new Object[0]);
            Object account = getAccountById.invoke(null, accountId);
            return (String)mGetAccountName.invoke(account, new Object[0]);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getVersion() {
        try {
            return (String)mGetVersion.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return "";
        }
    }

    static {
        try {
            Class<?> cls = Class.forName("kd.bos.context.RequestContext");
            mGetTraceId = cls.getMethod("getTraceId", new Class[0]);
            getRequestContext = cls.getMethod("get", new Class[0]);
            getAccountId = cls.getMethod("getAccountId", new Class[0]);
            getAccountById = Class.forName("kd.bos.dc.utils.AccountUtils").getMethod("getAccountById", String.class);
            mGetAccountName = Class.forName("kd.bos.dc.api.model.Account").getMethod("getAccountName", new Class[0]);
            mGetVersion = Class.forName("kd.bos.entity.BOSRuntime").getMethod("getVersion", new Class[0]);
        }
        catch (Exception e) {
            logger.warn("DefaultAuditLogContext static error.", (Throwable)e);
        }
    }
}

