/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.context;

import java.io.Serializable;
import kd.bos.util.ThreadLocals;

public class RequestTimeoutContext
implements Serializable {
    private static final ThreadLocal<RequestTimeoutContext> th = ThreadLocals.create();
    private String scene;
    private long startTime;
    private long timeout;
    private boolean isAutomaticTimeout;
    private boolean isTimeoutExceptionThrown;
    private String nextServerIp;
    private String requestOperation;
    private String appId;
    private boolean isTimeoutByManually;

    private RequestTimeoutContext() {
    }

    public RequestTimeoutContext(String scene, String operation, long timeout) {
        this.scene = scene;
        this.requestOperation = operation;
        this.timeout = timeout;
    }

    public static RequestTimeoutContext get() {
        return th.get();
    }

    public static void set(RequestTimeoutContext rtc) {
        th.set(rtc);
    }

    public boolean isAutomaticTimeout() {
        return this.isAutomaticTimeout;
    }

    public void setAutomaticTimeout(boolean automaticTimeout) {
        this.isAutomaticTimeout = automaticTimeout;
    }

    public boolean isTimeoutExceptionThrown() {
        return this.isTimeoutExceptionThrown;
    }

    public void setTimeoutExceptionThrown(boolean timeoutExceptionThrown) {
        this.isTimeoutExceptionThrown = timeoutExceptionThrown;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getScene() {
        return this.scene;
    }

    public void setScene(String scene) {
        this.scene = scene;
    }

    public boolean isWebRequest() {
        return "WebRequest".equals(this.scene);
    }

    public boolean isTimeoutByManually() {
        return this.isTimeoutByManually;
    }

    public void setTimeoutByManually(boolean timeoutByManually) {
        this.isTimeoutByManually = timeoutByManually;
    }

    public String getNextServerIp() {
        return this.nextServerIp;
    }

    public void setNextServerIp(String nextServerIp) {
        this.nextServerIp = nextServerIp;
    }

    public String getRequestOperation() {
        return this.requestOperation;
    }

    public RequestTimeoutContext setRequestOperation(String requestOperation) {
        this.requestOperation = requestOperation;
        return this;
    }

    public String getAppId() {
        return this.appId;
    }

    public RequestTimeoutContext setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public void clear() {
        th.remove();
    }
}

