/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.govern;

import kd.bos.util.ConfigurationUtil;

public class GovernConfigs {
    public static final String APM_STORAGE_TYPE = "apm.gov.invoke.report.storage.type";
    public static final String GOV_KEY_REPORTER_ES_URL = "gov.reporter.es.url";
    public static final String GOV_KEY_REPORTER_ES_USER = "gov.reporter.es.user";
    public static final String GOV_KEY_REPORTER_ES_PWD = "gov.reporter.es.pwd";
    public static final String GOV_KEY_REPORTER_ES_SSL_ENABLE = "gov.reporter.es.ssl.enable";
    public static final String GOV_KEY_REPORTER_ES_CERTIFICATE_PATH = "gov.reporter.es.certificate.path";
    public static final String GOV_KEY_REPORTER_ES_CERTIFICATE_PASSWORD = "gov.reporter.es.certificate.password";
    public static final String REPORT_TOPOLOGY_ENABLE = "gov.topology.enable";
    public static final String REPORT_APICALL_ENABLE = "gov.apicall.enable";
    public static final String GOV_TRACE_ENABLE = "gov.trace.enable";
    public static final String GOV_BREAKER_ENABLE = "gov.breaker.enable";
    public static final String GOV_METRIC_ENABLE = "gov.metric.enable";
    private static final String REPORT_QUEUESIZE = "gov.report.queuesize";
    private static final String REPORT_BATCHSIZE = "gov.report.batchsize";
    private static final String API_METADATA_CACHE_LIMIT = "gov.api.metadata.limit";
    private static final String API_METADATA_REPORT_WAIT_TIME = "gov.api.metadata.wait.time";
    private static final String REPORT_DEBUG_SYNC = "gov.report.debug.sync";
    private static final String WAIT_ENABLE = "gov.report.async.wait";
    private static final String REPORT_THREAD_NUM = "gov.report.thread.num";
    private static final String REPORT_LOG_WARN_NUM = "gov.report.log.warn.num";

    public static boolean getApicallEnable() {
        return Boolean.parseBoolean(System.getProperty(REPORT_APICALL_ENABLE, "false"));
    }

    public static boolean getTopologyEnable() {
        return Boolean.parseBoolean(System.getProperty(REPORT_TOPOLOGY_ENABLE, "false"));
    }

    public static boolean getBreakerEnable() {
        return Boolean.parseBoolean(System.getProperty(GOV_BREAKER_ENABLE, "false"));
    }

    public static boolean getTraceEnable() {
        return Boolean.parseBoolean(System.getProperty(GOV_TRACE_ENABLE, "false"));
    }

    public static boolean getReportDebugSync() {
        return Boolean.parseBoolean(System.getProperty(REPORT_DEBUG_SYNC, "false"));
    }

    public static int getReportQueueSize() {
        return ConfigurationUtil.getInteger((String)REPORT_QUEUESIZE, (Integer)100000);
    }

    public static int getReportThreadNum() {
        int num = ConfigurationUtil.getInteger((String)REPORT_THREAD_NUM, (Integer)2);
        return num > 5 ? 5 : num;
    }

    public static int getReportBatchSize() {
        return ConfigurationUtil.getInteger((String)REPORT_BATCHSIZE, (Integer)1024);
    }

    public static int getReportLogWarnNum() {
        return ConfigurationUtil.getInteger((String)REPORT_LOG_WARN_NUM, (Integer)10000);
    }

    public static boolean isWait() {
        return Boolean.getBoolean(WAIT_ENABLE);
    }

    public static int getApiMetadataCacheLimit() {
        return ConfigurationUtil.getInteger((String)API_METADATA_CACHE_LIMIT, (Integer)100000);
    }

    public static int getApiMetadataReportWaitTime() {
        return ConfigurationUtil.getInteger((String)API_METADATA_REPORT_WAIT_TIME, (Integer)300000);
    }
}

