/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.govern.timeout;

import java.lang.reflect.Field;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.timeout.ThreadTimeoutService;
import kd.bos.thread.ThreadLocalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadTimeoutManager {
    private static final Logger log = LoggerFactory.getLogger(ThreadTimeoutManager.class);
    private static ThreadTimeoutService threadTimeoutService;

    public static Thread getThreadByName(String threadName) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Thread[] threads = new Thread[group.activeCount()];
        group.enumerate(threads);
        for (Thread thread : threads) {
            if (thread == null || !thread.getName().equals(threadName)) continue;
            return thread;
        }
        return null;
    }

    public static Thread getThreadByTraceId(String traceId, String threadNamePrefix) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Thread[] threads = new Thread[group.activeCount()];
        group.enumerate(threads);
        for (Thread thread : threads) {
            if (thread == null || !thread.getName().startsWith(threadNamePrefix) || !thread.getName().contains(traceId)) continue;
            return thread;
        }
        return null;
    }

    public static <T> T getObject(Thread thread, String threadLocalFieldName, Class<T> objectType) {
        Object t = null;
        try {
            Field field = objectType.getDeclaredField(threadLocalFieldName);
            field.setAccessible(true);
            t = ThreadLocalUtils.getThreadLocalValue((Thread)thread, (ThreadLocal)((ThreadLocal)field.get(null)));
        }
        catch (Exception e) {
            log.error("ThreadTimeoutHandler get getObject failed. ", (Throwable)e);
        }
        return (T)t;
    }

    public static void terminateRequest(EventType eventType, String traceId, long threadId, String threadName) {
        threadTimeoutService.terminateRequest(eventType, traceId, threadId, threadName);
    }

    public static void terminateSql(EventType eventType, String traceId, long threadId, String threadName) {
        threadTimeoutService.terminateSql(eventType, traceId, threadId, threadName);
    }

    private ThreadTimeoutService getThreadTimeoutService() {
        return threadTimeoutService;
    }

    public static void setThreadTimeoutService(ThreadTimeoutService timeoutService) {
        threadTimeoutService = timeoutService;
    }
}

