/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.govern.timeout;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.govern.timeout.TimeoutHandle;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutHandleFactory {
    private static final Logger log = LoggerFactory.getLogger(TimeoutHandleFactory.class);
    private static boolean webRequestTimeoutEnable = Boolean.parseBoolean(System.getProperty("web.request.timeout.enable", "false"));

    private TimeoutHandleFactory() {
    }

    public static TimeoutHandle get() {
        return SingletonHolder.getInstance();
    }

    static {
        ConfigurationUtil.observeChange((String)"web.request.timeout.enable", (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                webRequestTimeoutEnable = Boolean.parseBoolean(System.getProperty("web.request.timeout.enable", "false"));
            }
        });
    }

    private static class SingletonHolder {
        private static final TimeoutHandle automaticImpl;
        private static final TimeoutHandle manualImpl;

        private SingletonHolder() {
        }

        public static TimeoutHandle getInstance() {
            return webRequestTimeoutEnable ? automaticImpl : manualImpl;
        }

        static {
            try {
                automaticImpl = (TimeoutHandle)Class.forName("kd.bos.mservice.timeout.AutomaticTimeoutHandleImpl").newInstance();
                manualImpl = (TimeoutHandle)Class.forName("kd.bos.mservice.timeout.ManualTimeoutHandleImpl").newInstance();
            }
            catch (Exception e) {
                log.error("TimeoutHandleFactory SingletonHolder init instance error:", (Throwable)e);
                throw new KDException(BosErrorCode.govRequestTimeout, new Object[]{e});
            }
        }
    }
}

