/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import kd.bos.metric.Counter;
import kd.bos.metric.Histogram;
import kd.bos.metric.Meter;
import kd.bos.metric.Metric;
import kd.bos.metric.MetricSystem;
import kd.bos.metric.Timer;

public class MetricClient {
    private String prefix;
    private ConcurrentHashMap<String, Metric> metrics = new ConcurrentHashMap();

    public MetricClient(String prefix) {
        this.prefix = prefix;
    }

    private Metric getOrAdd(String key, Supplier<Metric> supplier) {
        Metric metric = this.metrics.get(key);
        if (metric != null) {
            return metric;
        }
        metric = supplier.get();
        this.metrics.put(key, metric);
        return metric;
    }

    private String name(String suffix) {
        return this.prefix + "." + suffix;
    }

    public Meter meter(String suffix) {
        return (Meter)this.getOrAdd(suffix, () -> MetricSystem.meter(this.name(suffix)));
    }

    public Counter counter(String suffix) {
        return (Counter)this.getOrAdd(suffix, () -> MetricSystem.counter(this.name(suffix)));
    }

    public Timer timer(String suffix) {
        return (Timer)this.getOrAdd(suffix, () -> MetricSystem.timer(this.name(suffix)));
    }

    public Histogram histogram(String suffix) {
        return (Histogram)this.getOrAdd(suffix, () -> MetricSystem.histogram(this.name(suffix)));
    }
}

