/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.core;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reporter;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.jmx.JmxReporter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kd.bos.encrypt.Encrypters;
import kd.bos.extension.ExtensionFactory;
import kd.bos.metric.core.MetricTags;
import kd.bos.metric.reporter.Report;
import kd.bos.metric.reporter.cloudmetric.CloudMetricReporter;
import kd.bos.metric.reporter.cloudmetric.measurements.Sender;
import kd.bos.metric.reporter.common.CommonMetricsRepoter;
import kd.bos.metric.reporter.elasticsearch.ElasticSearchReporter;
import kd.bos.metric.reporter.kafka.KafkaReporter;
import kd.bos.metric.reporter.spi.SPIReport;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;
import metrics_influxdb.HttpInfluxdbProtocol;
import metrics_influxdb.InfluxdbProtocol;
import metrics_influxdb.InfluxdbReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricReporter {
    private static final Multimap<String, Reporter> runningReporters = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private static final Multimap<MetricRegistry, String> runningRegistries = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private static final ConcurrentHashMap<MetricRegistry, String> allRegistries = new ConcurrentHashMap();
    private static final String INFLUX_DB = "influxdb";
    private static final String CLOUD_METRIC = "cloudmetric";
    private static final String HA_WATCH = "hawatch";
    private static final String KAFKA = "kafka";
    private static final String ELASTICSEARCH = "elasticsearch";
    private static final String CONFIG_KEY = "metrics.reporter";
    private static final String CONFIG_KEY_TYPES = "metrics.reporter.types";
    private static final String CONFIG_KEY_INFLUX_DB = "metrics.reporter.influxdb";
    private static final String CONFIG_KEY_CLOUD_METRIC = "metrics.reporter.cloudmetric";
    private static final String CONFIG_KEY_HA_WATCH = "metrics.reporter.hawatch";
    private static final String CONFIG_KEY_KAFKA = "metrics.reporter.kafka";
    private static final String CONFIG_KEY_ELASTICSEARCH = "metrics.reporter.elasticsearch";
    private static final String NOT_CONFIGURED = " not configured.";
    private static final String UNKNOWN = "Unknown";
    private static final String CLUSTER_NAME = "clusterName";
    private static final String APP_NAME = "appName";
    private static final String KD_METRICS = "kdmetrics";
    private static final String CATEGORY = "category";
    private static final String METRIC_FILTER = "metricFilter";
    private static final String INTERVAL = "interval";
    private static final String CLIENT_IP = "clientIp";
    private static final String CLIENT_HOST_NAME = "clientHostName";
    private static final String METRIC_TAGS = "metricTags";
    private static Logger logger = LoggerFactory.getLogger(MetricReporter.class);
    private static String clientHostName;

    private static final Set<String> getConfigedReporters() {
        String types = System.getProperty(CONFIG_KEY_TYPES, "jmx");
        types = types.trim();
        HashSet<String> sets = new HashSet<String>();
        for (String report : types.split(",|\r|\n")) {
            if (report.trim().length() <= 0) continue;
            sets.add(report);
        }
        sets.add(ELASTICSEARCH);
        return sets;
    }

    private static void initListener() {
        ConfigurationUtil.observeChange((String)CONFIG_KEY_TYPES, (key, newValue) -> MetricReporter.typesChanged((String)newValue));
    }

    private static void typesChanged(String types) {
        HashSet<String> sets = new HashSet<String>();
        for (String report : types.split(",")) {
            sets.add(report.trim());
        }
        Set runningSet = runningReporters.keySet();
        runningSet.stream().filter(type -> !sets.contains(type)).forEach(MetricReporter::stop);
        sets.stream().filter(type -> !runningSet.contains(type)).forEach(MetricReporter::start);
    }

    public static void startHAWatch() {
        if (!MetricReporter.isRunning(HA_WATCH)) {
            MetricReporter.start(HA_WATCH);
        }
    }

    public static void stopHAWatch() {
        if (MetricReporter.isRunning(HA_WATCH)) {
            MetricReporter.stop(HA_WATCH);
        }
    }

    private static boolean isRunning(String type) {
        return runningReporters.containsKey((Object)type);
    }

    private static void stop(String type) {
        runningReporters.removeAll((Object)type).stream().forEach(reporter -> {
            try {
                reporter.close();
            }
            catch (Exception e) {
                logger.error("MetricReporter stop error:", (Throwable)e);
            }
        });
        allRegistries.keySet().stream().forEach(registry -> runningRegistries.remove(registry, (Object)type));
    }

    private static void start(String type) {
        allRegistries.keySet().stream().filter(registry -> !runningRegistries.containsEntry(registry, (Object)type)).forEach(registry -> MetricReporter.start(registry, type));
    }

    private static void start(MetricRegistry registry, String reporter) {
        String domain = allRegistries.get(registry);
        MetricReporter.startRepoter(reporter, domain, registry);
    }

    public static void register(String domain, MetricRegistry registry) {
        allRegistries.put(registry, domain);
        Set<String> reporters = MetricReporter.getConfigedReporters();
        for (String reporter : reporters) {
            MetricReporter.startRepoter(reporter, domain, registry);
        }
    }

    private static void startRepoter(String reporter, String domain, MetricRegistry registry) {
        switch (reporter = reporter.toLowerCase()) {
            case "jmx": {
                MetricReporter.reportJmx(domain, registry);
                break;
            }
            case "influxdb": {
                MetricReporter.reportInfluxdb(domain, registry);
                break;
            }
            case "cloudmetric": {
                MetricReporter.reportCloudMetric(domain, registry);
                break;
            }
            case "hawatch": {
                MetricReporter.reportHaWatch(domain, registry);
                break;
            }
            case "kafka": {
                MetricReporter.reportKafka(domain, registry);
                break;
            }
            case "elasticsearch": {
                MetricReporter.reportElasticsearch(domain, registry);
                break;
            }
            default: {
                MetricReporter.reportBySPI(reporter, domain, registry);
            }
        }
    }

    private static boolean reportCloudMetric(String domain, MetricRegistry registry) {
        try {
            String value;
            String[] metricTags;
            String config = System.getProperty(CONFIG_KEY_CLOUD_METRIC);
            if (config == null) {
                logger.error("metrics.reporter.cloudmetric not configured.");
                return false;
            }
            String clusterName = System.getProperty(CLUSTER_NAME, UNKNOWN);
            String appName = System.getProperty(APP_NAME, UNKNOWN);
            String clientIp = NetAddressUtils.getLocalIpAddress();
            Properties props = new Properties();
            props.load(new StringReader(config));
            String url = props.getProperty("url");
            String token = props.getProperty("token", "");
            String category = props.getProperty(CATEGORY, KD_METRICS);
            MetricFilter metricFilter = MetricReporter.createMetricFilter(props.getProperty(METRIC_FILTER));
            int interval = Integer.parseInt(props.getProperty(INTERVAL, "30"));
            CloudMetricReporter.Builder builder = CloudMetricReporter.forRegistry(registry).url(url).category(category).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(metricFilter).skipIdleMetrics(false).token(token).tag(CLUSTER_NAME, clusterName).tag(APP_NAME, appName).tag(CLIENT_IP, clientIp).tag(CLIENT_HOST_NAME, clientHostName);
            String metricTagsStr = props.getProperty(METRIC_TAGS, "");
            for (String tag : metricTags = metricTagsStr.split(",")) {
                if (StringUtils.isEmpty((String)tag)) continue;
                value = System.getProperty(tag, UNKNOWN);
                builder.tag(tag, value);
            }
            for (String key : MetricTags.threadKeys) {
                value = (String)ThreadTruck.get((Object)key);
                if (value == null) continue;
                builder.tag(key, value);
            }
            ScheduledReporter reporter = builder.build();
            reporter.start((long)interval, TimeUnit.SECONDS);
            runningReporters.put((Object)CLOUD_METRIC, (Object)reporter);
            runningRegistries.put((Object)registry, (Object)CLOUD_METRIC);
            return true;
        }
        catch (Exception t) {
            logger.warn("error when report to cloudmetric", (Throwable)t);
            return false;
        }
    }

    private static MetricFilter createMetricFilter(String value) {
        if (value == null) {
            return MetricFilter.ALL;
        }
        String[] parts = value.split(";|,");
        final HashSet<String> set = new HashSet<String>();
        for (String part : parts) {
            set.add(part.trim());
        }
        return new MetricFilter(){

            public boolean matches(String name, Metric metric) {
                return set.contains(name);
            }
        };
    }

    private static boolean reportInfluxdb(String domain, MetricRegistry registry) {
        try {
            String config = System.getProperty(CONFIG_KEY_INFLUX_DB);
            if (config == null) {
                logger.error("metrics.reporter.influxdb not configured.");
                return false;
            }
            String clusterName = System.getProperty(CLUSTER_NAME, UNKNOWN);
            String appName = System.getProperty(APP_NAME, UNKNOWN);
            String clientIp = NetAddressUtils.getLocalIpAddress();
            Properties props = new Properties();
            props.load(new StringReader(config));
            String host = props.getProperty("host");
            int port = Integer.parseInt(props.getProperty("port"));
            String user = props.getProperty("user");
            String password = props.getProperty("password");
            password = Encrypters.decode((String)password);
            String db = props.getProperty("db", KD_METRICS);
            int interval = Integer.parseInt(props.getProperty(INTERVAL, "30"));
            InfluxdbReporter.Builder builder = InfluxdbReporter.forRegistry((MetricRegistry)registry).protocol((InfluxdbProtocol)new HttpInfluxdbProtocol("http", host, port, user, password, db)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).skipIdleMetrics(false).tag(CLUSTER_NAME, clusterName).tag(APP_NAME, appName).tag(CLIENT_IP, clientIp).tag(CLIENT_HOST_NAME, clientHostName);
            ScheduledReporter reporter = builder.build();
            reporter.start((long)interval, TimeUnit.SECONDS);
            runningReporters.put((Object)INFLUX_DB, (Object)reporter);
            runningRegistries.put((Object)registry, (Object)INFLUX_DB);
            return true;
        }
        catch (Exception t) {
            logger.error("error when report to influxdb", (Throwable)t);
            return false;
        }
    }

    private static boolean reportHaWatch(String domain, MetricRegistry registry) {
        try {
            String[] metricTags;
            String config = System.getProperty(CONFIG_KEY_HA_WATCH, "category=kdmetrics");
            if (config == null) {
                logger.error("metrics.reporter not configured.");
                return false;
            }
            String clusterName = System.getProperty(CLUSTER_NAME, UNKNOWN);
            String appName = System.getProperty(APP_NAME, UNKNOWN);
            String clientIp = NetAddressUtils.getLocalIpAddress();
            Properties props = new Properties();
            props.load(new StringReader(config));
            int interval = 10;
            String category = props.getProperty(CATEGORY, KD_METRICS);
            MetricFilter metricFilter = MetricReporter.createMetricFilter(props.getProperty(METRIC_FILTER));
            Class<?> clz = Class.forName("kd.bos.ha.watch.reporter.HaWatchSender");
            Sender sender = (Sender)clz.newInstance();
            CommonMetricsRepoter.Builder builder = CommonMetricsRepoter.forRegistry(registry).category(category).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(metricFilter).withSender(sender).skipIdleMetrics(false).tag(CLUSTER_NAME, clusterName).tag(APP_NAME, appName).tag(CLIENT_IP, clientIp).tag(CLIENT_HOST_NAME, clientHostName);
            String metricTagsStr = props.getProperty(METRIC_TAGS, "");
            for (String tag : metricTags = metricTagsStr.split(",")) {
                if (StringUtils.isEmpty((String)tag)) continue;
                String value = System.getProperty(tag, UNKNOWN);
                builder.tag(tag, value);
            }
            ScheduledReporter reporter = builder.build();
            reporter.start((long)interval, TimeUnit.SECONDS);
            runningReporters.put((Object)HA_WATCH, (Object)reporter);
            runningRegistries.put((Object)registry, (Object)HA_WATCH);
            return true;
        }
        catch (Exception t) {
            logger.error("error when report to hawatch", (Throwable)t);
            return false;
        }
    }

    private static void reportJmx(String domain, MetricRegistry registry) {
        JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)registry).inDomain(domain).build();
        reporter.start();
        runningReporters.put((Object)"jmx", (Object)reporter);
        runningRegistries.put((Object)registry, (Object)"jmx");
    }

    private static boolean reportKafka(String domain, MetricRegistry registry) {
        try {
            String[] metricTags;
            String config = System.getProperty(CONFIG_KEY_KAFKA);
            if (config == null) {
                logger.error("metrics.reporter not configured.");
                return false;
            }
            String clusterName = System.getProperty(CLUSTER_NAME, UNKNOWN);
            String appName = System.getProperty(APP_NAME, UNKNOWN);
            String clientIp = NetAddressUtils.getLocalIpAddress();
            Properties props = new Properties();
            props.load(new StringReader(config));
            String host = props.getProperty("host");
            String topic = props.getProperty("topic");
            String user = props.getProperty("user");
            String password = props.getProperty("password");
            int interval = Integer.parseInt(props.getProperty(INTERVAL, "15"));
            String category = props.getProperty(CATEGORY, KD_METRICS);
            MetricFilter metricFilter = MetricReporter.createMetricFilter(props.getProperty(METRIC_FILTER));
            KafkaReporter.Builder builder = KafkaReporter.forRegistry(registry).category(category).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(metricFilter).getSender(host, topic, user, password).skipIdleMetrics(false).tag(CLUSTER_NAME, clusterName).tag(APP_NAME, appName).tag(CLIENT_IP, clientIp).tag(CLIENT_HOST_NAME, clientHostName);
            String metricTagsStr = props.getProperty(METRIC_TAGS, "");
            for (String tag : metricTags = metricTagsStr.split(",")) {
                if (StringUtils.isEmpty((String)tag)) continue;
                String value = System.getProperty(tag, UNKNOWN);
                builder.tag(tag, value);
            }
            ScheduledReporter reporter = builder.build();
            reporter.start((long)interval, TimeUnit.SECONDS);
            runningReporters.put((Object)KAFKA, (Object)reporter);
            runningRegistries.put((Object)registry, (Object)KAFKA);
            return true;
        }
        catch (Exception t) {
            logger.error("error when report to kafka", (Throwable)t);
            return false;
        }
    }

    private static boolean reportElasticsearch(String domain, MetricRegistry registry) {
        try {
            String property = System.getProperty("metrics.reporter.elasticsearch.interval", "10");
            int interval = Integer.parseInt(property);
            ElasticSearchReporter.Builder builder = ElasticSearchReporter.forRegistry(registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).skipIdleMetrics(false).tag(CLIENT_HOST_NAME, clientHostName);
            ScheduledReporter reporter = builder.build();
            reporter.start((long)interval, TimeUnit.SECONDS);
            runningReporters.put((Object)ELASTICSEARCH, (Object)reporter);
            runningRegistries.put((Object)registry, (Object)ELASTICSEARCH);
        }
        catch (Exception e) {
            logger.warn("Exception occurred when send metrics by elasticsearch", (Throwable)e);
            return false;
        }
        return true;
    }

    private static boolean reportBySPI(String reporterType, String domain, MetricRegistry registry) {
        try {
            String paramConfig = new StringBuffer().append(CONFIG_KEY).append(".").append(reporterType).toString();
            String config = System.getProperty(paramConfig);
            Properties props = new Properties();
            if (config != null) {
                props.load(new StringReader(config));
            } else {
                logger.warn("{} not configured.", (Object)paramConfig);
            }
            int interval = Integer.parseInt(props.getProperty(INTERVAL, "15"));
            MetricFilter metricFilter = MetricReporter.createMetricFilter(props.getProperty(METRIC_FILTER));
            ExtensionFactory extensionFactory = ExtensionFactory.getExtensionFacotry(Report.class);
            Report report = (Report)extensionFactory.getExtension(reporterType);
            logger.info("Metrcis spi load class : {}", (Object)report.getClass().getName());
            SPIReport reporter = new SPIReport(report, registry, reporterType, metricFilter, TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
            reporter.start(interval, TimeUnit.SECONDS);
            runningReporters.put((Object)reporterType, (Object)reporter);
            runningRegistries.put((Object)registry, (Object)reporterType);
            return true;
        }
        catch (Exception e) {
            logger.warn("Exception occurred when send metrics by reportBySPI", (Throwable)e);
            return false;
        }
    }

    static {
        MetricReporter.initListener();
        clientHostName = System.getProperty("dockerHostName");
        if (clientHostName == null) {
            try {
                clientHostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.warn("MetricReporter static error:", (Throwable)e);
            }
        }
    }
}

