/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.instruments.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import kd.bos.metric.Counter;
import kd.bos.metric.Meter;
import kd.bos.metric.MetricSystem;
import kd.bos.metric.Timer;
import kd.bos.thread.ThreadTruck;

public class MetricFilter
implements Filter {
    private static final String CONFIG_PREFIX_KEY = "metric.servletfilter.prefix";
    private static final String NAME_PREFIX = "responseCodes.";
    private static final int OK = 200;
    private static final int CREATED = 201;
    private static final int NO_CONTENT = 204;
    private static final int BAD_REQUEST = 400;
    private static final int NOT_FOUND = 404;
    private static final int SERVER_ERROR = 500;
    private final Map<Integer, String> meterNamesByStatusCode;
    private String prefix = System.getProperty("metric.servletfilter.prefix", this.prefix);
    private ConcurrentMap<Integer, Meter> metersByStatusCode;
    private Meter otherMeter;
    private Meter timeoutsMeter;
    private Meter errorsMeter;
    private Counter activeRequests;
    private Timer requestTimer;
    private String otherMetricName;

    public MetricFilter() {
        this.meterNamesByStatusCode = new HashMap<Integer, String>(6);
        this.meterNamesByStatusCode.put(200, "responseCodes.ok");
        this.meterNamesByStatusCode.put(201, "responseCodes.created");
        this.meterNamesByStatusCode.put(204, "responseCodes.noContent");
        this.meterNamesByStatusCode.put(400, "responseCodes.badRequest");
        this.meterNamesByStatusCode.put(404, "responseCodes.notFound");
        this.meterNamesByStatusCode.put(500, "responseCodes.serverError");
        this.otherMetricName = "responseCodes.other";
        this.metersByStatusCode = new ConcurrentHashMap<Integer, Meter>(this.meterNamesByStatusCode.size());
        for (Map.Entry<Integer, String> entry : this.meterNamesByStatusCode.entrySet()) {
            this.metersByStatusCode.put(entry.getKey(), MetricSystem.meter(this.name(entry.getValue())));
        }
        this.otherMeter = MetricSystem.meter(this.name(this.otherMetricName));
        this.timeoutsMeter = MetricSystem.meter(this.name("timeouts"));
        this.errorsMeter = MetricSystem.meter(this.name("errors"));
        this.activeRequests = MetricSystem.counter(this.name("activeRequests"));
        this.requestTimer = MetricSystem.timer(this.name("requestTimer"));
    }

    private String name(String suffix) {
        return this.prefix + suffix;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String servletPath = ((HttpServletRequest)request).getServletPath();
        ThreadTruck.put((Object)"metric.url", (Object)servletPath);
        StatusExposingServletResponse wrappedResponse = new StatusExposingServletResponse((HttpServletResponse)response);
        this.activeRequests.inc();
        Timer.Context context = this.requestTimer.time();
        boolean error = false;
        try {
            chain.doFilter(request, (ServletResponse)wrappedResponse);
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        catch (ServletException e) {
            error = true;
            throw e;
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            if (!error && request.isAsyncStarted()) {
                request.getAsyncContext().addListener((AsyncListener)new AsyncResultListener(context));
            } else {
                context.stop();
                this.activeRequests.dec();
                if (error) {
                    this.errorsMeter.mark();
                } else {
                    this.markMeterForStatusCode(wrappedResponse.getStatus());
                }
            }
        }
    }

    private void markMeterForStatusCode(int status) {
        Meter metric = (Meter)this.metersByStatusCode.get(status);
        if (metric != null) {
            metric.mark();
        } else {
            this.otherMeter.mark();
        }
    }

    public void init(FilterConfig arg0) {
    }

    private class AsyncResultListener
    implements AsyncListener {
        private Timer.Context context;
        private boolean done = false;

        public AsyncResultListener(Timer.Context context) {
            this.context = context;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            if (!this.done) {
                HttpServletResponse suppliedResponse = (HttpServletResponse)event.getSuppliedResponse();
                this.context.stop();
                MetricFilter.this.activeRequests.dec();
                MetricFilter.this.markMeterForStatusCode(suppliedResponse.getStatus());
            }
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            this.context.stop();
            MetricFilter.this.activeRequests.dec();
            MetricFilter.this.timeoutsMeter.mark();
            this.done = true;
        }

        public void onError(AsyncEvent event) throws IOException {
            this.context.stop();
            MetricFilter.this.activeRequests.dec();
            MetricFilter.this.errorsMeter.mark();
            this.done = true;
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }
    }

    private static class StatusExposingServletResponse
    extends HttpServletResponseWrapper {
        private int httpStatus = 200;

        public StatusExposingServletResponse(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int sc) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc, msg);
        }

        public void setStatus(int sc, String sm) {
            this.httpStatus = sc;
            super.setStatus(sc, sm);
        }

        public int getStatus() {
            return this.httpStatus;
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
            super.setStatus(sc);
        }
    }
}

