/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.reporter;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.sun.management.GcInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.management.openmbean.CompositeData;
import kd.bos.util.JmxUtils;

public class GarbageCollectorMetricSet
implements MetricSet {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private final List<GarbageCollectorMXBean> gcMxBeans;

    public GarbageCollectorMetricSet() {
        this(ManagementFactory.getGarbageCollectorMXBeans());
    }

    public GarbageCollectorMetricSet(Collection<GarbageCollectorMXBean> garbageCollectors) {
        this.gcMxBeans = new ArrayList<GarbageCollectorMXBean>(garbageCollectors);
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Gauge> gauges = new HashMap<String, Gauge>(8);
        try {
            if ("G1".equals(this.getGcType())) {
                Object fullGC = JmxUtils.getAtt((String)"java.lang:type=GarbageCollector,name=G1 Old Generation", (String)"LastGcInfo");
                if (fullGC != null) {
                    GcInfo gcInfo = GcInfo.from((CompositeData)fullGC);
                    long time = gcInfo == null ? 0L : gcInfo.getDuration();
                    long id = gcInfo == null ? 0L : gcInfo.getId();
                    gauges.put(MetricRegistry.name((String)"G1-Old-Generation", (String[])new String[]{"time"}), () -> time);
                    gauges.put(MetricRegistry.name((String)"G1-Old-Generation", (String[])new String[]{"count"}), () -> id);
                } else {
                    gauges.put(MetricRegistry.name((String)"G1-Old-Generation", (String[])new String[]{"time"}), () -> 0L);
                    gauges.put(MetricRegistry.name((String)"G1-Old-Generation", (String[])new String[]{"count"}), () -> 0L);
                }
                Object yongGC = JmxUtils.getAtt((String)"java.lang:type=GarbageCollector,name=G1 Young Generation", (String)"LastGcInfo");
                if (yongGC != null) {
                    GcInfo gcInfo = GcInfo.from((CompositeData)yongGC);
                    long time = gcInfo == null ? 0L : gcInfo.getDuration();
                    long id = gcInfo == null ? 0L : gcInfo.getId();
                    gauges.put(MetricRegistry.name((String)"G1-Young-Generation", (String[])new String[]{"time"}), () -> time);
                    gauges.put(MetricRegistry.name((String)"G1-Young-Generation", (String[])new String[]{"count"}), () -> id);
                } else {
                    gauges.put(MetricRegistry.name((String)"G1-Young-Generation", (String[])new String[]{"time"}), () -> 0L);
                    gauges.put(MetricRegistry.name((String)"G1-Young-Generation", (String[])new String[]{"count"}), () -> 0L);
                }
            } else {
                for (GarbageCollectorMXBean gc : this.gcMxBeans) {
                    String name = WHITESPACE.matcher(gc.getName()).replaceAll("-");
                    gauges.put(MetricRegistry.name((String)name, (String[])new String[]{"count"}), () -> gc.getCollectionCount());
                    gauges.put(MetricRegistry.name((String)name, (String[])new String[]{"time"}), () -> gc.getCollectionTime());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.unmodifiableMap(gauges);
    }

    private String getGcType() {
        try {
            for (GarbageCollectorMXBean gcMxBean : this.gcMxBeans) {
                if (!gcMxBean.getName().contains("G1")) continue;
                return "G1";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "default";
    }
}

