/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.reporter.cloudmetric;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionNumber
implements Comparable<VersionNumber> {
    private static final Pattern _regexp = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?([-\\.].+)?");
    int major;
    int minor;
    int bugfix;
    String modifier;

    public VersionNumber() {
        this.major = 0;
        this.minor = 0;
        this.bugfix = 0;
    }

    public VersionNumber(String s) {
        String group4;
        Matcher match = _regexp.matcher(s);
        if (!match.find()) {
            throw new IllegalArgumentException("invalid versionNumber : major.minor(.bugfix)(modifier) :" + s);
        }
        this.major = Integer.parseInt(match.group(1));
        this.minor = Integer.parseInt(match.group(2));
        String group3 = match.group(3);
        if (group3 != null && group3.length() > 1) {
            this.bugfix = Integer.parseInt(group3.substring(1));
        }
        if ((group4 = match.group(4)) != null && group4.length() > 1) {
            this.modifier = group4;
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.major).append('.').append(this.minor).append('.').append(this.bugfix);
        if (this.modifier != null && this.modifier.length() > 0) {
            str.append(this.modifier);
        }
        return str.toString();
    }

    @Override
    public int compareTo(VersionNumber o) {
        int back = 0;
        if (back == 0 && this.major > o.major) {
            back = 1;
        }
        if (back == 0 && this.major < o.major) {
            back = -1;
        }
        if (back == 0 && this.minor > o.minor) {
            back = 1;
        }
        if (back == 0 && this.minor < o.minor) {
            back = -1;
        }
        if (back == 0 && this.bugfix > o.bugfix) {
            back = 1;
        }
        if (back == 0 && this.bugfix < o.bugfix) {
            back = -1;
        }
        return back;
    }

    public boolean isZero() {
        return this.major == 0 && this.minor == 0 && this.bugfix == 0;
    }
}

