/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.reporter.cloudmetric.measurements;

import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import kd.bos.metric.reporter.cloudmetric.measurements.AbstractSender;
import kd.bos.metric.reporter.cloudmetric.measurements.Measure;
import kd.bos.metric.reporter.cloudmetric.misc.BoundedFIFO;

public class QueueableSender
extends AbstractSender {
    private static final int Max_MeasureCacheTime = 30;
    private int maxCacheTime;
    private final Collection<Measure> measures;
    private int queueSize;
    private Date lastDoSendTime = new Date();

    protected QueueableSender(int queueSize) {
        this(queueSize, 30);
    }

    protected QueueableSender(int queueSize, int maxCacheTime) {
        this.queueSize = queueSize;
        this.maxCacheTime = maxCacheTime;
        this.measures = new BoundedFIFO<Measure>(queueSize);
    }

    @Override
    public void flush() {
        if (this.doSend(this.measures)) {
            this.measures.clear();
        }
    }

    @Override
    public void send(Measure m) {
        if (m == null) {
            return;
        }
        Date needSendTime = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(needSendTime);
        c.add(13, -this.maxCacheTime);
        needSendTime = c.getTime();
        if ((this.measures.size() >= this.queueSize || this.lastDoSendTime.before(needSendTime)) && this.doSend(this.measures)) {
            this.measures.clear();
            this.lastDoSendTime = new Date();
        }
        this.measures.add(m);
    }

    protected boolean doSend(Collection<Measure> measuresToSend) {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.measures.clear();
    }
}

