/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.reporter.common;

import com.codahale.metrics.Clock;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.metric.reporter.cloudmetric.api.measurements.MetricMeasurementTransformer;
import kd.bos.metric.reporter.cloudmetric.measurements.MeasurementReporter;
import kd.bos.metric.reporter.cloudmetric.measurements.Sender;
import kd.bos.metric.reporter.cloudmetric.misc.Miscellaneous;

public class CommonMetricsRepoter {
    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Map<String, String> tags;
        private MetricMeasurementTransformer measurementTransformer = MetricMeasurementTransformer.NOOP;
        private Clock clock;
        private String fCategory;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter metricFilter;
        private ScheduledExecutorService executor;
        private boolean fSkipIdleMetrics;
        private Sender sender;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.metricFilter = MetricFilter.ALL;
            this.tags = new HashMap<String, String>();
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder withScheduler(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder category(String category) {
            this.fCategory = category;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.metricFilter = filter;
            return this;
        }

        public Builder withSender(Sender s) {
            this.sender = s;
            return this;
        }

        public Builder skipIdleMetrics(boolean skipIdleMetrics) {
            this.fSkipIdleMetrics = skipIdleMetrics;
            return this;
        }

        public boolean isSkipIdleMetrics() {
            return this.fSkipIdleMetrics;
        }

        public ScheduledReporter build() {
            if (this.sender == null) {
                throw new NullPointerException("Sender must be provided");
            }
            MeasurementReporter reporter = this.executor == null ? new MeasurementReporter(this.sender, this.fCategory, this.registry, this.metricFilter, this.rateUnit, this.durationUnit, this.clock, this.tags, this.measurementTransformer) : new MeasurementReporter(this.sender, this.fCategory, this.registry, this.metricFilter, this.rateUnit, this.durationUnit, this.clock, this.tags, this.measurementTransformer, this.executor);
            return reporter;
        }

        public Builder transformer(MetricMeasurementTransformer transformer) {
            Objects.requireNonNull(transformer, "given MetricMeasurementTransformer cannot be null");
            this.measurementTransformer = transformer;
            return this;
        }

        public Builder tag(String tagKey, String tagValue) {
            Miscellaneous.requireNotEmptyParameter(tagKey, "tag");
            Miscellaneous.requireNotEmptyParameter(tagValue, "value");
            this.tags.put(tagKey, tagValue);
            return this;
        }
    }
}

