/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.reporter.elasticsearch;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.govern.GovernPoJo;
import kd.bos.instance.Instance;
import kd.bos.util.NetAddressUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsPoJo<T extends Metric>
extends GovernPoJo {
    private String type;
    private Map<String, T> data;
    private long timestamp;
    private static final String INSTANCE_ID = Instance.getInstanceId();
    private static final String APP_NAME = Instance.getAppName();
    private static final String LOCAL_IP;
    private static final Logger log;

    public MetricsPoJo(String type, long timestamp, Map<String, T> data) {
        this.type = type;
        this.timestamp = timestamp;
        this.data = data;
    }

    @Override
    public Map<String, Object> data2map() {
        SimpleDateFormat xAxisFormat = new SimpleDateFormat("yyyy-MM-dd\nHH:mm:ss");
        HashMap<String, Object> map = new HashMap<String, Object>(32);
        for (Map.Entry<String, T> next : this.data.entrySet()) {
            try {
                HashMap<String, Number> temp;
                Metric value = (Metric)next.getValue();
                if (value instanceof Gauge) {
                    map.put(next.getKey(), ((Gauge)value).getValue());
                    continue;
                }
                if (value instanceof Counter) {
                    map.put(next.getKey(), ((Counter)value).getCount());
                    continue;
                }
                if (value instanceof Timer) {
                    Timer timer = (Timer)value;
                    temp = new HashMap<String, Number>(32);
                    temp.put("count", timer.getCount());
                    temp.put("m15_rate", timer.getFifteenMinuteRate());
                    temp.put("m5_rate", timer.getFiveMinuteRate());
                    temp.put("m1_rate", timer.getOneMinuteRate());
                    temp.put("mean_rate", timer.getMeanRate());
                    Snapshot snapshot = timer.getSnapshot();
                    temp.put("max", snapshot.getMax());
                    temp.put("min", snapshot.getMin());
                    temp.put("mean", snapshot.getMean());
                    temp.put("std_dev", snapshot.getStdDev());
                    temp.put("p50", snapshot.getMedian());
                    temp.put("p75", snapshot.get75thPercentile());
                    temp.put("p95", snapshot.get95thPercentile());
                    temp.put("p98", snapshot.get98thPercentile());
                    temp.put("p99", snapshot.get99thPercentile());
                    temp.put("p999", snapshot.get999thPercentile());
                    map.put(next.getKey(), temp);
                    continue;
                }
                if (!(value instanceof Meter)) continue;
                Meter meter = (Meter)value;
                temp = new HashMap(8);
                temp.put("count", meter.getCount());
                temp.put("m15_rate", meter.getFifteenMinuteRate());
                temp.put("m5_rate", meter.getFiveMinuteRate());
                temp.put("m1_rate", meter.getOneMinuteRate());
                temp.put("mean_rate", meter.getMeanRate());
                map.put(next.getKey(), temp);
            }
            catch (Exception e) {
                log.debug("report " + next.getKey() + " error!", (Throwable)e);
            }
        }
        map.put("xAxis", xAxisFormat.format(new Date(this.timestamp)));
        SimpleDateFormat beijingDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        beijingDateFormat.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        String beijingFormattedStr = beijingDateFormat.format(new Date(this.timestamp));
        map.put("timestampUtc", beijingFormattedStr);
        map.put("timestamp", this.timestamp);
        map.put("instanceId", INSTANCE_ID);
        map.put("appName", APP_NAME);
        map.put("ip", LOCAL_IP);
        map.put("metrics_type", this.type);
        return map;
    }

    static {
        log = LoggerFactory.getLogger(MetricsPoJo.class);
        String LOCAL_IP1 = NetAddressUtils.getLocalIpAddress();
        if (NetAddressUtils.isPreferIPv6() && !LOCAL_IP1.startsWith("[")) {
            LOCAL_IP1 = "[" + LOCAL_IP1 + "]";
        }
        LOCAL_IP = LOCAL_IP1;
    }
}

