/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.reporter.kafka;

import java.util.Properties;
import kd.bos.metric.reporter.kafka.IKafkaSender;
import kd.bos.metric.reporter.kafka.KafkaMessage;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaSender<T>
implements IKafkaSender<T> {
    private Properties props;
    private Producer<String, T> producer;

    public KafkaSender(Properties props) {
        this.props = props;
    }

    @Override
    public void send(KafkaMessage<T> kafkaMsg) {
        if (this.producer == null) {
            this.producer = new KafkaProducer(this.props);
        }
        if (kafkaMsg.getTopic() == null) {
            throw new RuntimeException("Metrics Kafka producer topic can not be null");
        }
        this.producer.send(new ProducerRecord(kafkaMsg.getTopic(), kafkaMsg.getMsg()));
    }

    @Override
    public void close() {
        if (this.producer != null) {
            this.producer.close();
        }
    }
}

