/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.perflog;

import java.util.HashSet;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfLoggerConfig {
    private static Logger logger = LoggerFactory.getLogger(PerfLoggerConfig.class);
    private static final String configKey = "perfLog";
    private static final String configKey_enabled = "perfLog.enable";
    private static final String configKey_types = "perfLog.types";
    private static boolean enabledLog = false;
    private static HashSet<String> logTypes = new HashSet();

    private static void loadConfig() {
        try {
            String enableStr = System.getProperty(configKey_enabled);
            if (StringUtils.isEmpty((String)enableStr)) {
                enableStr = "false";
            }
            enabledLog = "true".equals(enableStr);
            String logTypesStr = System.getProperty(configKey_types);
            if (StringUtils.isNotEmpty((String)logTypesStr)) {
                for (String type : logTypesStr.split(",")) {
                    logTypes.add(type.trim());
                }
            }
        }
        catch (Exception ex) {
            logger.error("PerfLog Configuration error.", (Throwable)ex);
        }
    }

    public static boolean isLogEnable(String type) {
        return enabledLog && logTypes.contains(type);
    }

    static {
        PerfLoggerConfig.loadConfig();
        ConfigurationUtil.observeChange((String)configKey_enabled, (key, newValue) -> PerfLoggerConfig.loadConfig());
        ConfigurationUtil.observeChange((String)configKey_types, (key, newValue) -> PerfLoggerConfig.loadConfig());
    }
}

