/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.slowlog;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SlowLogger {
    private static final Logger logger = LoggerFactory.getLogger(SlowLogger.class);
    private static final String LEVEL = System.getProperty("slowlogger.level", "error");
    private static SlowLogger instance;

    public static void setInstance(SlowLogger logger) {
        instance = logger;
    }

    public static void log(String message) {
        if (instance != null) {
            instance.log0(message);
        }
    }

    protected abstract void log0(String var1);

    public static void log(String message, Object ... args) {
        if ("warn".equalsIgnoreCase(LEVEL)) {
            logger.warn(message, args);
        } else if ("info".equalsIgnoreCase(LEVEL)) {
            logger.info(message, args);
        } else if ("debug".equalsIgnoreCase(LEVEL)) {
            logger.debug(message, args);
        } else {
            logger.error(message, args);
        }
    }
}

