/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kd.bos.instance.Instance;
import kd.bos.trace.core.Log;
import kd.bos.trace.core.SpanContext;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;

public class InnerSpan
implements SpanContext {
    public static final String SAMPLED_NAME = "X-B3-Sampled";
    public static final String PROCESS_ID_NAME = "X-Process-Id";
    public static final String PARENT_ID_NAME = "X-B3-ParentSpanId";
    public static final String TRACE_ID_NAME = "X-B3-TraceId";
    public static final String SPAN_NAME_NAME = "X-Span-Name";
    public static final String SPAN_ID_NAME = "X-B3-SpanId";
    public static final String SPAN_EXPORT_NAME = "X-Span-Export";
    public static final String SPAN_FLAGS = "X-B3-Flags";
    public static final String SPAN_BAGGAGE_HEADER_PREFIX = "baggage";
    protected static final Set<String> SPAN_HEADERS = new HashSet<String>(Arrays.asList("X-B3-Sampled", "X-Process-Id", "X-B3-ParentSpanId", "X-B3-TraceId", "X-B3-SpanId", "X-Span-Name", "X-Span-Export"));
    public static final String SPAN_SAMPLED = "1";
    public static final String SPAN_NOT_SAMPLED = "0";
    public static final String SPAN_LOCAL_COMPONENT_TAG_NAME = "lc";
    public static final String SPAN_ERROR_TAG_NAME = "error";
    public static final String CLIENT_RECV = "cr";
    public static final String CLIENT_SEND = "cs";
    public static final String SERVER_RECV = "sr";
    public static final String SERVER_SEND = "ss";
    public static final String SPAN_PEER_SERVICE_TAG_NAME = "peer.service";
    public static final String INSTANCEID = "instance_id";
    private final long fBegin;
    private final String fName;
    private final long fTraceId;
    private final long fSpanId;
    private final Map<String, String> tagMap;
    private final String fProcessId;
    private final Collection<Log> logList;
    private final InnerSpan savedInnerSpan;
    private final Map<String, String> baggageMap;
    private final Long startNanos;
    private long fEnd = 0L;
    private List<Long> parentList = new ArrayList<Long>(1);
    private boolean fRemote = false;
    private boolean fIsCrossNode = false;
    private boolean fExportable = true;
    private Long durationMicros;
    private String fInstanceId = Instance.getInstanceId();

    public InnerSpan(InnerSpan current, InnerSpan savedInnerSpan) {
        this.fBegin = current.getBegin();
        this.fEnd = current.getEnd();
        this.fName = current.getName();
        this.fTraceId = current.getTraceId();
        this.parentList = current.getParents();
        this.fSpanId = current.getSpanId();
        this.fRemote = current.isRemote();
        this.fExportable = current.isExportable();
        this.fProcessId = current.getProcessId();
        this.tagMap = current.tagMap;
        this.logList = current.logList;
        this.startNanos = current.startNanos;
        this.durationMicros = current.durationMicros;
        this.baggageMap = current.baggageMap;
        this.savedInnerSpan = savedInnerSpan;
        this.fIsCrossNode = current.fIsCrossNode;
    }

    public InnerSpan(SpanBuilder builder) {
        if (builder.fBegin > 0L) {
            this.startNanos = null;
            this.fBegin = builder.fBegin;
        } else {
            this.startNanos = this.nanoTime();
            this.fBegin = System.currentTimeMillis();
        }
        if (builder.fEnd > 0L) {
            this.fEnd = builder.fEnd;
            this.durationMicros = (this.fEnd - this.fBegin) * 1000L;
        }
        this.fName = builder.fName != null ? builder.fName : "";
        this.fTraceId = builder.fTraceId;
        this.parentList.addAll(builder.parentList);
        this.fSpanId = builder.fSpanId;
        this.fRemote = builder.fRemote;
        this.fIsCrossNode = builder.fIsCrossNode;
        this.fExportable = builder.fExportable;
        this.fProcessId = builder.fProcessId;
        this.savedInnerSpan = builder.savedInnerSpan;
        if (StringUtils.isNotEmpty((String)builder.fInstanceId)) {
            this.fInstanceId = builder.fInstanceId;
        }
        this.tagMap = new ConcurrentHashMap<String, String>();
        this.tagMap.putAll(builder.tagMap);
        this.logList = new ConcurrentLinkedQueue<Log>();
        this.logList.addAll(builder.logList);
        this.baggageMap = new ConcurrentHashMap<String, String>();
        this.baggageMap.putAll(builder.baggageMap);
    }

    public static SpanBuilder builder() {
        return new SpanBuilder();
    }

    public static String idToHex(long id) {
        return TraceIdUtil.idToHex(id);
    }

    public static long hexToId(String hexString) {
        return TraceIdUtil.hexToId(hexString);
    }

    public static long hexToId(String lowerHex, int index) {
        return TraceIdUtil.hexToId(lowerHex, index);
    }

    public synchronized void stop() {
        if (this.durationMicros == null) {
            if (this.fBegin == 0L) {
                throw new IllegalStateException("Span for " + this.fName + " has not been started");
            }
            if (this.fEnd == 0L) {
                this.fEnd = System.currentTimeMillis();
            }
            this.durationMicros = this.startNanos != null ? Long.valueOf(Math.max(1L, (this.nanoTime() - this.startNanos) / 1000L)) : Long.valueOf((this.fEnd - this.fBegin) * 1000L);
        }
    }

    @Deprecated
    public synchronized long getAccumulatedMillis() {
        return this.getAccumulatedMicros() / 1000L;
    }

    public synchronized long getAccumulatedMicros() {
        if (this.durationMicros != null) {
            return this.durationMicros;
        }
        if (this.fBegin == 0L) {
            return 0L;
        }
        if (this.startNanos != null) {
            return Math.max(1L, (this.nanoTime() - this.startNanos) / 1000L);
        }
        return (System.currentTimeMillis() - this.fBegin) * 1000L;
    }

    long nanoTime() {
        return System.nanoTime();
    }

    public synchronized boolean isRunning() {
        return this.fBegin != 0L && this.durationMicros == null;
    }

    public void tag(String key, String value) {
        if (null != value) {
            this.tagMap.put(key, value);
        }
    }

    public void logEvent(String event) {
        this.logEvent(System.currentTimeMillis(), event);
    }

    public void logEvent(long timestampMilliseconds, String event) {
        this.logList.add(new Log(timestampMilliseconds, event));
    }

    public Map<String, String> tags() {
        return Collections.unmodifiableMap(new LinkedHashMap<String, String>(this.tagMap));
    }

    public List<Log> logs() {
        return Collections.unmodifiableList(new ArrayList<Log>(this.logList));
    }

    public InnerSpan setBaggageItem(String key, String value) {
        this.baggageMap.put(key, value);
        return this;
    }

    public String getBaggageItem(String key) {
        return this.baggageMap.get(key);
    }

    @Override
    public final Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggageMap.entrySet();
    }

    public final Map<String, String> getBaggage() {
        return Collections.unmodifiableMap(this.baggageMap);
    }

    public InnerSpan getSavedSpan() {
        return this.savedInnerSpan;
    }

    public boolean hasSavedSpan() {
        return this.savedInnerSpan != null;
    }

    public String getName() {
        return this.fName;
    }

    public long getSpanId() {
        return this.fSpanId;
    }

    public long getTraceIdHigh() {
        return 0L;
    }

    public long getTraceId() {
        return this.fTraceId;
    }

    public String getProcessId() {
        return this.fProcessId;
    }

    public List<Long> getParents() {
        return this.parentList;
    }

    public boolean isRemote() {
        return this.fRemote;
    }

    public String getInstanceId() {
        return this.fInstanceId;
    }

    public long getBegin() {
        return this.fBegin;
    }

    public long getEnd() {
        return this.fEnd;
    }

    public long getDurationMicros() {
        return this.durationMicros;
    }

    public int getCost() {
        if (this.fEnd > 0L) {
            return (int)(this.fEnd - this.fBegin);
        }
        return (int)(System.currentTimeMillis() - this.fBegin);
    }

    public boolean isExportable() {
        return this.fExportable;
    }

    public boolean isCrossNode() {
        return this.fIsCrossNode;
    }

    public String traceIdString() {
        return InnerSpan.idToHex(this.fTraceId);
    }

    public String toString() {
        return "[Trace: " + this.fTraceId + ", Span: " + this.fSpanId + ", Parent: " + this.getParentIdIfPresent() + ", exportable:" + this.fExportable + "]";
    }

    private String getParentIdIfPresent() {
        return this.getParents().isEmpty() ? "null" : InnerSpan.idToHex(this.getParents().get(0));
    }

    public int hashCode() {
        return Long.hashCode(this.fTraceId);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InnerSpan) {
            InnerSpan that = (InnerSpan)o;
            return this.fTraceId == that.fTraceId && this.fSpanId == that.fSpanId;
        }
        return false;
    }

    public static class SpanBuilder {
        private long fBegin;
        private long fEnd;
        private String fName;
        private long fTraceId;
        private long fSpanId;
        private final ArrayList<Long> parentList = new ArrayList();
        private String fInstanceId;
        private boolean fRemote;
        private boolean fIsCrossNode;
        private boolean fExportable = true;
        private String fProcessId;
        private InnerSpan savedInnerSpan;
        private final List<Log> logList = new ArrayList<Log>();
        private final Map<String, String> tagMap = new LinkedHashMap<String, String>();
        private final Map<String, String> baggageMap = new LinkedHashMap<String, String>();

        SpanBuilder() {
        }

        public SpanBuilder begin(long begin) {
            this.fBegin = begin;
            return this;
        }

        public SpanBuilder end(long end) {
            this.fEnd = end;
            return this;
        }

        public SpanBuilder name(String name) {
            this.fName = name;
            return this;
        }

        public SpanBuilder isCrossNode(boolean isCrossNode) {
            this.fIsCrossNode = isCrossNode;
            return this;
        }

        public SpanBuilder traceId(long traceId) {
            this.fTraceId = traceId;
            return this;
        }

        public SpanBuilder parent(long parent) {
            this.parentList.add(parent);
            return this;
        }

        public SpanBuilder parents(Collection<Long> parents) {
            this.parentList.addAll(parents);
            return this;
        }

        public SpanBuilder log(Log log) {
            this.logList.add(log);
            return this;
        }

        public SpanBuilder logs(Collection<Log> logs) {
            this.logList.addAll(logs);
            return this;
        }

        public SpanBuilder tag(String tagKey, String tagValue) {
            this.tagMap.put(tagKey, tagValue);
            return this;
        }

        public SpanBuilder tags(Map<String, String> tags) {
            this.tagMap.putAll(tags);
            return this;
        }

        public SpanBuilder baggage(String baggageKey, String baggageValue) {
            this.baggageMap.put(baggageKey, baggageValue);
            return this;
        }

        public SpanBuilder baggage(Map<String, String> baggage) {
            this.baggageMap.putAll(baggage);
            return this;
        }

        public SpanBuilder spanId(long spanId) {
            this.fSpanId = spanId;
            return this;
        }

        public SpanBuilder remote(boolean remote) {
            this.fRemote = remote;
            return this;
        }

        public SpanBuilder instanceId(String instanceId) {
            this.fInstanceId = instanceId;
            return this;
        }

        public SpanBuilder exportable(boolean exportable) {
            this.fExportable = exportable;
            return this;
        }

        public SpanBuilder processId(String processId) {
            this.fProcessId = processId;
            return this;
        }

        public SpanBuilder savedSpan(InnerSpan savedSpan) {
            this.savedInnerSpan = savedSpan;
            return this;
        }

        public InnerSpan build() {
            return new InnerSpan(this);
        }

        public String toString() {
            return new InnerSpan(this).toString();
        }
    }
}

