/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.core;

import java.util.concurrent.Callable;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.InnerTracer;
import kd.bos.trace.core.SpanNamer;

public class TraceCallable<V>
implements Callable<V> {
    private final InnerTracer tracer;
    private final SpanNamer spanNamer;
    private final Callable<V> delegate;
    private final String name;
    private final InnerSpan parent;

    public TraceCallable(InnerTracer tracer, SpanNamer spanNamer, Callable<V> delegate) {
        this(tracer, spanNamer, delegate, null);
    }

    public TraceCallable(InnerTracer tracer, SpanNamer spanNamer, Callable<V> delegate, String name) {
        this.tracer = tracer;
        this.spanNamer = spanNamer;
        this.delegate = delegate;
        this.name = name;
        this.parent = tracer.getCurrentSpan();
    }

    @Override
    public V call() {
        InnerSpan span = this.startSpan();
        try {
            V v = this.getDelegate().call();
            return v;
        }
        catch (Exception e) {
            throw new IllegalStateException("apm TraceCallable.call error", e);
        }
        finally {
            this.close(span);
        }
    }

    protected InnerSpan startSpan() {
        return this.tracer.createSpan(this.getSpanName(), this.parent);
    }

    protected String getSpanName() {
        if (this.name != null) {
            return this.name;
        }
        return this.spanNamer.name(this.delegate, "async");
    }

    protected void close(InnerSpan span) {
        this.tracer.close(span);
    }

    protected InnerSpan continueSpan(InnerSpan span) {
        return this.tracer.continueSpan(span);
    }

    protected InnerSpan detachSpan(InnerSpan span) {
        return this.tracer.detach(span);
    }

    public InnerTracer getTracer() {
        return this.tracer;
    }

    public Callable<V> getDelegate() {
        return this.delegate;
    }

    public String getName() {
        return this.name;
    }

    public InnerSpan getParent() {
        return this.parent;
    }
}

