/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.core;

import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.InnerTracer;
import kd.bos.trace.core.SpanNamer;

public class TraceRunnable
implements Runnable {
    private static final String DEFAULT_SPAN_NAME = "async";
    private final InnerTracer tracer;
    private final SpanNamer spanNamer;
    private final Runnable delegate;
    private final String name;
    private final InnerSpan parent;

    public TraceRunnable(InnerTracer tracer, SpanNamer spanNamer, Runnable delegate) {
        this(tracer, spanNamer, delegate, null);
    }

    public TraceRunnable(InnerTracer tracer, SpanNamer spanNamer, Runnable delegate, String name) {
        this.tracer = tracer;
        this.spanNamer = spanNamer;
        this.delegate = delegate;
        this.name = name;
        this.parent = tracer.getCurrentSpan();
    }

    @Override
    public void run() {
        InnerSpan span = this.startSpan();
        try {
            this.getDelegate().run();
        }
        finally {
            this.close(span);
        }
    }

    protected InnerSpan startSpan() {
        return this.tracer.createSpan(this.getSpanName(), this.parent);
    }

    protected String getSpanName() {
        if (this.name != null) {
            return this.name;
        }
        return this.spanNamer.name(this.delegate, DEFAULT_SPAN_NAME);
    }

    protected void close(InnerSpan span) {
        if (!this.tracer.isTracing()) {
            this.tracer.continueSpan(span);
        }
        this.tracer.close(span);
    }

    protected InnerSpan continueSpan(InnerSpan span) {
        return this.tracer.continueSpan(span);
    }

    protected InnerSpan detachSpan(InnerSpan span) {
        if (this.tracer.isTracing()) {
            return this.tracer.detach(span);
        }
        return span;
    }

    public InnerTracer getTracer() {
        return this.tracer;
    }

    public Runnable getDelegate() {
        return this.delegate;
    }

    public String getName() {
        return this.name;
    }

    public InnerSpan getParent() {
        return this.parent;
    }
}

