/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.instrument.async;

import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.InnerTracer;
import kd.bos.trace.core.SpanNamer;
import kd.bos.trace.core.TraceKeys;
import kd.bos.trace.core.TraceRunnable;

public class LocalComponentTraceRunnable
extends TraceRunnable {
    protected static final String ASYNC_COMPONENT = "async";
    private final TraceKeys traceKeys;

    public LocalComponentTraceRunnable(InnerTracer tracer, TraceKeys traceKeys, SpanNamer spanNamer, Runnable delegate) {
        super(tracer, spanNamer, delegate);
        this.traceKeys = traceKeys;
    }

    public LocalComponentTraceRunnable(InnerTracer tracer, TraceKeys traceKeys, SpanNamer spanNamer, Runnable delegate, String name) {
        super(tracer, spanNamer, delegate, name);
        this.traceKeys = traceKeys;
    }

    @Override
    public void run() {
        InnerSpan span = this.startSpan();
        try {
            this.getDelegate().run();
        }
        finally {
            this.close(span);
        }
    }

    @Override
    protected InnerSpan startSpan() {
        InnerSpan span = this.getTracer().createSpan(this.getSpanName(), this.getParent());
        this.getTracer().addTag("lc", ASYNC_COMPONENT);
        this.getTracer().addTag(this.traceKeys.getAsync().getPrefix() + this.traceKeys.getAsync().getThreadNameKey(), Thread.currentThread().getName());
        return span;
    }
}

