/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.instrument.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.concurrent.Executor;
import kd.bos.trace.instrument.jdbc.JdbcTrace;
import kd.bos.trace.instrument.jdbc.PreparedStatementAOP;
import kd.bos.trace.instrument.jdbc.SQLTraceId;
import kd.bos.trace.instrument.jdbc.StatementAOP;
import kd.bos.trace.tracer.MemSpanTrace;
import kd.bos.util.jdbcproxy.ConnectionProxy;

public class ConnectionAOP
extends ConnectionProxy {
    private static final String PREPARE_STATEMENT = "connection.prepareStatement";
    private static final String PREPARE_CALL = "prepareCall";

    public ConnectionAOP(Connection conn) {
        super(conn);
    }

    protected String wrapSQL(String sql) {
        return SQLTraceId.wrapWithTraceId(sql);
    }

    public Statement createStatement() throws SQLException {
        return new StatementAOP(super.createStatement());
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new StatementAOP(super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new StatementAOP(super.createStatement(resultSetType, resultSetConcurrency));
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            JdbcTrace.executeBefore(sql, PREPARE_STATEMENT);
            PreparedStatementAOP preparedStatementAOP = new PreparedStatementAOP(super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
            return preparedStatementAOP;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            JdbcTrace.executeAfter(sql, null, (Connection)((Object)this));
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            JdbcTrace.executeBefore(sql, PREPARE_STATEMENT);
            PreparedStatementAOP preparedStatementAOP = new PreparedStatementAOP(super.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
            return preparedStatementAOP;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            JdbcTrace.executeAfter(sql, null, (Connection)((Object)this));
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            JdbcTrace.executeBefore(sql, PREPARE_STATEMENT);
            PreparedStatementAOP preparedStatementAOP = new PreparedStatementAOP(super.prepareStatement(sql, autoGeneratedKeys), sql);
            return preparedStatementAOP;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            JdbcTrace.executeAfter(sql, null, (Connection)((Object)this));
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            JdbcTrace.executeBefore(sql, PREPARE_STATEMENT);
            PreparedStatementAOP preparedStatementAOP = new PreparedStatementAOP(super.prepareStatement(sql, columnIndexes), sql);
            return preparedStatementAOP;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            JdbcTrace.executeAfter(sql, null, (Connection)((Object)this));
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            JdbcTrace.executeBefore(sql, PREPARE_STATEMENT);
            PreparedStatementAOP preparedStatementAOP = new PreparedStatementAOP(super.prepareStatement(sql, columnNames), sql);
            return preparedStatementAOP;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            JdbcTrace.executeAfter(sql, null, (Connection)((Object)this));
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            JdbcTrace.executeBefore(sql, PREPARE_STATEMENT);
            PreparedStatementAOP preparedStatementAOP = new PreparedStatementAOP(super.prepareStatement(sql), sql);
            return preparedStatementAOP;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            JdbcTrace.executeAfter(sql, null, (Connection)((Object)this));
        }
    }

    private MemSpanTrace getInstruments(String method) {
        MemSpanTrace span = MemSpanTrace.create("ConnectionAOP", method);
        return span;
    }

    public void close() throws SQLException {
        try (MemSpanTrace clos = this.getInstruments("close");){
            super.close();
        }
    }

    public void commit() throws SQLException {
        try (MemSpanTrace clos = this.getInstruments("commit");){
            super.commit();
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        try (MemSpanTrace clos = this.getInstruments("nativeSQL");){
            String string = super.nativeSQL(sql);
            return string;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try (MemSpanTrace clos = this.getInstruments(PREPARE_CALL);){
            CallableStatement callableStatement = super.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            return callableStatement;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try (MemSpanTrace clos = this.getInstruments(PREPARE_CALL);){
            CallableStatement callableStatement = super.prepareCall(sql, resultSetType, resultSetConcurrency);
            return callableStatement;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        try (MemSpanTrace clos = this.getInstruments(PREPARE_CALL);){
            CallableStatement callableStatement = super.prepareCall(sql);
            return callableStatement;
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try (MemSpanTrace clos = this.getInstruments("releaseSavepoint");){
            super.releaseSavepoint(savepoint);
        }
    }

    public void rollback() throws SQLException {
        try (MemSpanTrace clos = this.getInstruments("rollback");){
            super.rollback();
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        try (MemSpanTrace clos = this.getInstruments("rollback");){
            super.rollback(savepoint);
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        try (MemSpanTrace clos = this.getInstruments("setSavepoint");){
            Savepoint savepoint = super.setSavepoint();
            return savepoint;
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        try (MemSpanTrace clos = this.getInstruments("setSavepoint");){
            Savepoint savepoint = super.setSavepoint(name);
            return savepoint;
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        try (MemSpanTrace clos = this.getInstruments("setTransactionIsolation");){
            super.setTransactionIsolation(level);
        }
    }

    public Clob createClob() throws SQLException {
        try (MemSpanTrace clos = this.getInstruments("createClob");){
            Clob clob = super.createClob();
            return clob;
        }
    }

    public Blob createBlob() throws SQLException {
        try (MemSpanTrace clos = this.getInstruments("createClob");){
            Blob blob = super.createBlob();
            return blob;
        }
    }

    public NClob createNClob() throws SQLException {
        try (MemSpanTrace clos = this.getInstruments("createNClob");){
            NClob nClob = super.createNClob();
            return nClob;
        }
    }

    public SQLXML createSQLXML() throws SQLException {
        try (MemSpanTrace clos = this.getInstruments("createSQLXML");){
            SQLXML sQLXML = super.createSQLXML();
            return sQLXML;
        }
    }

    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try (MemSpanTrace clos = this.getInstruments("createArrayOf");){
            Array array = super.createArrayOf(typeName, elements);
            return array;
        }
    }

    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try (MemSpanTrace clos = this.getInstruments("createStruct");){
            Struct struct = super.createStruct(typeName, attributes);
            return struct;
        }
    }

    public void abort(Executor executor) throws SQLException {
        try (MemSpanTrace clos = this.getInstruments("abort");){
            super.abort(executor);
        }
    }
}

