/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.instrument.jdbc;

import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.hint.SQLHintUtils;

final class SQLTraceId {
    private static final String dialect_prefix = "/*dialect*/";
    private static final int dialectPrefixLength = "/*dialect*/".length();
    private static final Pattern tracePattern = Pattern.compile("[a-zA-Z0-9]{1,16}");
    private static final boolean appendTraceId = Boolean.getBoolean("db.sql.withTraceId");

    SQLTraceId() {
    }

    static String wrapWithTraceId(String sql) {
        String wrapQingHint = SQLHintUtils.getWrapSQLHints();
        if (appendTraceId) {
            String traceId = SQLTraceId.getTraceId();
            if (traceId == null || traceId.isEmpty()) {
                return sql;
            }
            boolean isDialect = false;
            if ((sql = sql.trim()).startsWith(dialect_prefix)) {
                isDialect = true;
                sql = sql.substring(dialectPrefixLength);
                while (sql.startsWith(dialect_prefix)) {
                    sql = sql.substring(dialectPrefixLength);
                }
            }
            if (!tracePattern.matcher(traceId).matches()) {
                throw new IllegalArgumentException("uncorrect traceId: " + traceId);
            }
            if (isDialect) {
                return "/*dialect*//*+" + traceId + "*/" + wrapQingHint + sql;
            }
            return "/*+" + traceId + "*/" + wrapQingHint + sql;
        }
        return wrapQingHint + sql;
    }

    static String getTraceId() {
        Map rcinfo = (Map)ThreadTruck.get((Object)"rcinfo");
        if (rcinfo == null) {
            return null;
        }
        return (String)rcinfo.get("traceId");
    }
}

