/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.instrument.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import kd.bos.trace.instrument.jdbc.JdbcTrace;
import kd.bos.trace.instrument.jdbc.SQLTraceId;
import kd.bos.util.jdbcproxy.StatementProxy;

public class StatementAOP
extends StatementProxy {
    private static final String EXECUTE_FIELD = "statement.execute";
    private static final String EXECUTE_UPDATE = "statement.executeUpdate";

    public StatementAOP(Statement delegate) {
        super(delegate);
    }

    protected String wrapSQL(String sql) {
        return SQLTraceId.wrapWithTraceId(sql);
    }

    public void addBatch(String sql) throws SQLException {
        super.addBatch(sql);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        SQLException error = null;
        try {
            JdbcTrace.executeBefore(sql, EXECUTE_FIELD);
            boolean bl = super.execute(sql, autoGeneratedKeys);
            return bl;
        }
        catch (SQLException e) {
            error = e;
            throw e;
        }
        finally {
            JdbcTrace.executeAfter(sql, error, this.getConnection());
        }
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        SQLException error = null;
        try {
            JdbcTrace.executeBefore(sql, EXECUTE_FIELD);
            boolean bl = super.execute(sql, columnIndexes);
            return bl;
        }
        catch (SQLException e) {
            error = e;
            throw e;
        }
        finally {
            JdbcTrace.executeAfter(sql, error, this.getConnection());
        }
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        SQLException error = null;
        try {
            JdbcTrace.executeBefore(sql, EXECUTE_FIELD);
            boolean bl = super.execute(sql, columnNames);
            return bl;
        }
        catch (SQLException e) {
            error = e;
            throw e;
        }
        finally {
            JdbcTrace.executeAfter(sql, error, this.getConnection());
        }
    }

    public boolean execute(String sql) throws SQLException {
        SQLException error = null;
        try {
            JdbcTrace.executeBefore(sql, EXECUTE_FIELD);
            boolean bl = super.execute(sql);
            return bl;
        }
        catch (SQLException e) {
            error = e;
            throw e;
        }
        finally {
            JdbcTrace.executeAfter(sql, error, this.getConnection());
        }
    }

    public int[] executeBatch() throws SQLException {
        SQLException error = null;
        try {
            JdbcTrace.executeBefore(null, "statement.executeBatch");
            int[] nArray = super.executeBatch();
            return nArray;
        }
        catch (SQLException e) {
            error = e;
            throw e;
        }
        finally {
            JdbcTrace.executeAfter(null, error, this.getConnection());
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        SQLException error = null;
        try {
            JdbcTrace.executeBefore(sql, "statement.executeQuery");
            ResultSet resultSet = super.executeQuery(sql);
            return resultSet;
        }
        catch (SQLException e) {
            error = e;
            throw e;
        }
        finally {
            JdbcTrace.executeAfter(sql, error, this.getConnection());
        }
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        SQLException error = null;
        try {
            JdbcTrace.executeBefore(sql, EXECUTE_UPDATE);
            int n = super.executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
        catch (SQLException e) {
            error = e;
            throw e;
        }
        finally {
            JdbcTrace.executeAfter(sql, error, this.getConnection());
        }
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        SQLException error = null;
        try {
            JdbcTrace.executeBefore(sql, EXECUTE_UPDATE);
            int n = super.executeUpdate(sql, columnIndexes);
            return n;
        }
        catch (SQLException e) {
            error = e;
            throw e;
        }
        finally {
            JdbcTrace.executeAfter(sql, error, this.getConnection());
        }
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        SQLException error = null;
        try {
            JdbcTrace.executeBefore(sql, EXECUTE_UPDATE);
            int n = super.executeUpdate(sql, columnNames);
            return n;
        }
        catch (SQLException e) {
            error = e;
            throw e;
        }
        finally {
            JdbcTrace.executeAfter(sql, error, this.getConnection());
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        SQLException error = null;
        try {
            JdbcTrace.executeBefore(sql, EXECUTE_UPDATE);
            int n = super.executeUpdate(sql);
            return n;
        }
        catch (SQLException e) {
            error = e;
            throw e;
        }
        finally {
            JdbcTrace.executeAfter(sql, error, this.getConnection());
        }
    }
}

