/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.reporter;

import kd.bos.trace.core.InnerSpanReporter;
import kd.bos.trace.reporter.NoOpInnerSpanReporter;
import kd.bos.trace.reporter.sword.SwordReport;
import kd.bos.trace.reporter.zipkin.ZipkinFactory;

public class InnerSpanReporterFactory {
    private static final String DEBUG = ".debug";
    private static final InnerSpanReporter NOOP_REPORTER = new NoOpInnerSpanReporter();
    private static InnerSpanReporter reporter;

    public static InnerSpanReporter getSpanReporter() {
        if (reporter != null) {
            return reporter;
        }
        boolean debug = Boolean.getBoolean("gov.trace.reporter.debug");
        String type = System.getProperty("gov.trace.reporter.type" + (debug ? DEBUG : ""), "sword");
        if ("sword".equals(type)) {
            reporter = new SwordReport();
        } else if ("zipkin".equals(type)) {
            reporter = InnerSpanReporterFactory.getHttpReporter(debug);
        } else if ("zipkin-kafka".equals(type)) {
            reporter = InnerSpanReporterFactory.getKafkaReporter(debug);
        } else if (!"".equals(type)) {
            reporter = InnerSpanReporterFactory.getReporter(type);
            if (reporter == null) {
                reporter = NOOP_REPORTER;
            }
        } else {
            reporter = NOOP_REPORTER;
        }
        return reporter;
    }

    private static InnerSpanReporter getKafkaReporter(boolean debug) {
        String url = System.getProperty("trace.reporter.zipkin.kafka.url" + (debug ? DEBUG : ""));
        if (url == null) {
            return NOOP_REPORTER;
        }
        String topic = System.getProperty("trace.reporter.zipkin.kafka.topic" + (debug ? DEBUG : ""), "zipkin");
        return ZipkinFactory.createKafkaReporter(url, topic);
    }

    private static InnerSpanReporter getHttpReporter(boolean debug) {
        String url = System.getProperty("trace.reporter.zipkin.url" + (debug ? DEBUG : ""));
        if (url != null) {
            return ZipkinFactory.createHttpReporter(url);
        }
        return NOOP_REPORTER;
    }

    private static InnerSpanReporter getReporter(String type) {
        return ZipkinFactory.createReporter(type);
    }
}

