/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.reporter;

import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import kd.bos.metric.Counter;
import kd.bos.metric.MetricSystem;
import kd.bos.thread.ThreadEndClear;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.InnerSpanReporter;
import kd.bos.trace.core.Log;
import kd.bos.trace.reporter.zipkin.EndpointLocator;
import kd.bos.trace.reporter.zipkin.ZipkinSpanReporter;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.async.SetQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Endpoint;
import zipkin.Span;

public class ZipkinInnerSpanReporter
implements InnerSpanReporter {
    private static final Set<String> ZIPKIN_START_EVENTS = new HashSet<String>(Arrays.asList("cr", "sr"));
    private static final Set<String> RPC_EVENTS = new HashSet<String>(Arrays.asList("cr", "cs", "sr", "ss"));
    private static final Logger log = LoggerFactory.getLogger(ZipkinInnerSpanReporter.class);
    private static final String SINGLE_STR = "zipkin.trace.report.single";
    private static final String MAXCACHE_STR = "zipkin.async.maxcache.count";
    private static final String WAITWHENFULL_STR = "zipkin.trace.report.async.waitwhenfull";
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final byte[] UNKNOWN_BYTES = "unknown".getBytes(UTF_8);
    private static Counter discardCount = MetricSystem.counter("trace.sync.span.discardCount");
    private static Counter consumeCount = MetricSystem.counter("trace.sync.span.consumeCount");
    private static Counter totalCount = MetricSystem.counter("trace.sync.span.totalCount");
    private static Map<Long, ConcurrentLinkedQueue<InnerSpan>> spanMaps = new ConcurrentHashMap<Long, ConcurrentLinkedQueue<InnerSpan>>();
    private static Map<Long, SpanTask> runnableMaps = new ConcurrentHashMap<Long, SpanTask>();
    private static SetQueue<SpanTask> queue = new SetQueue();
    private static AtomicInteger totalSpanCount = new AtomicInteger(0);
    private final ZipkinSpanReporter reporter;
    private EndpointLocator endpointLocator;

    public ZipkinInnerSpanReporter(ZipkinSpanReporter reporter, EndpointLocator endpointLocator) {
        this.reporter = reporter;
        this.endpointLocator = endpointLocator;
    }

    Span convert(InnerSpan span) {
        Span.Builder zipkinSpan = Span.builder();
        Endpoint endpoint = this.endpointLocator.local();
        if (span.tags().containsKey("service")) {
            endpoint = endpoint.toBuilder().serviceName(span.tags().get("service")).build();
        }
        span.tag("ip", NetAddressUtils.getLocalIpAddress());
        this.processLogs(span, zipkinSpan, endpoint);
        this.addZipkinAnnotations(zipkinSpan, span, endpoint);
        this.addZipkinBinaryAnnotations(zipkinSpan, span, endpoint);
        if (!span.isRemote()) {
            zipkinSpan.timestamp(Long.valueOf(span.getBegin() * 1000L));
            if (!span.isRunning()) {
                zipkinSpan.duration(Long.valueOf(this.calculateDurationInMicros(span)));
            }
        }
        zipkinSpan.traceIdHigh(span.getTraceIdHigh());
        zipkinSpan.traceId(span.getTraceId());
        if (span.getParents().size() > 0) {
            zipkinSpan.parentId(span.getParents().get(0));
        }
        zipkinSpan.id(span.getSpanId());
        if (StringUtils.isNotEmpty((String)span.getName())) {
            zipkinSpan.name(span.getName());
        }
        return zipkinSpan.build();
    }

    private void ensureLocalComponent(InnerSpan span, Span.Builder zipkinSpan, Endpoint localEndpoint) {
        if (span.tags().containsKey("lc")) {
            return;
        }
        byte[] processId = span.getProcessId() != null ? span.getProcessId().toLowerCase().getBytes(UTF_8) : UNKNOWN_BYTES;
        BinaryAnnotation component = BinaryAnnotation.builder().type(BinaryAnnotation.Type.STRING).key("lc").value(processId).endpoint(localEndpoint).build();
        zipkinSpan.addBinaryAnnotation(component);
    }

    private void ensureServerAddr(InnerSpan span, Span.Builder zipkinSpan, Endpoint localEndpoint) {
        if (span.tags().containsKey("peer.service")) {
            zipkinSpan.addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)localEndpoint.toBuilder().serviceName(span.tags().get("peer.service")).build()));
        }
    }

    private void processLogs(InnerSpan span, Span.Builder zipkinSpan, Endpoint endpoint) {
        boolean notClientOrServer = true;
        boolean hasClientSend = false;
        boolean instanceIdToTag = false;
        for (Log log : span.logs()) {
            if (RPC_EVENTS.contains(log.getEvent())) {
                instanceIdToTag = true;
            }
            if (ZIPKIN_START_EVENTS.contains(log.getEvent())) {
                notClientOrServer = false;
            }
            if (!"cs".equals(log.getEvent())) continue;
            hasClientSend = !span.tags().containsKey("sa");
        }
        if (notClientOrServer) {
            this.ensureLocalComponent(span, zipkinSpan, endpoint);
        }
        if (hasClientSend) {
            this.ensureServerAddr(span, zipkinSpan, endpoint);
        }
    }

    private void setInstanceIdIfPresent(Span.Builder zipkinSpan, Endpoint endpoint, String key) {
        String property = ManagementFactory.getRuntimeMXBean().getName();
        if (StringUtils.isNotEmpty((String)property)) {
            this.addZipkinBinaryAnnotation(key, property, endpoint, zipkinSpan);
        }
    }

    private void addZipkinAnnotations(Span.Builder zipkinSpan, InnerSpan span, Endpoint endpoint) {
        for (Log ta : span.logs()) {
            Annotation zipkinAnnotation = Annotation.builder().endpoint(endpoint).timestamp(ta.getTimestamp() * 1000L).value(ta.getEvent()).build();
            zipkinSpan.addAnnotation(zipkinAnnotation);
        }
    }

    private void addZipkinBinaryAnnotations(Span.Builder zipkinSpan, InnerSpan span, Endpoint ep) {
        for (Map.Entry<String, String> e : span.tags().entrySet()) {
            this.addZipkinBinaryAnnotation(e.getKey(), e.getValue(), ep, zipkinSpan);
        }
    }

    private void addZipkinBinaryAnnotation(String key, String value, Endpoint ep, Span.Builder zipkinSpan) {
        BinaryAnnotation binaryAnn = BinaryAnnotation.builder().type(BinaryAnnotation.Type.STRING).key(key).value(value.getBytes(UTF_8)).endpoint(ep).build();
        zipkinSpan.addBinaryAnnotation(binaryAnn);
    }

    private long calculateDurationInMicros(InnerSpan span) {
        Log clientSend = this.hasLog("cs", span);
        Log clientReceived = this.hasLog("cr", span);
        if (clientSend != null && clientReceived != null) {
            return (clientReceived.getTimestamp() - clientSend.getTimestamp()) * 1000L;
        }
        return span.getAccumulatedMicros();
    }

    private Log hasLog(String logName, InnerSpan span) {
        for (Log log : span.logs()) {
            if (!logName.equals(log.getEvent())) continue;
            return log;
        }
        return null;
    }

    @Override
    public void report(InnerSpan span) {
        if (span.isExportable()) {
            totalCount.inc();
            long threadId = Thread.currentThread().getId();
            ConcurrentLinkedQueue spanLs = spanMaps.computeIfAbsent(threadId, key -> {
                runnableMaps.put(threadId, new SpanTask(threadId));
                return new ConcurrentLinkedQueue();
            });
            queue.putIfAbsent((Object)runnableMaps.get(threadId));
            int maxQueueSize = Integer.getInteger(MAXCACHE_STR, 100000);
            if (totalSpanCount.get() < maxQueueSize) {
                spanLs.add(span);
                totalSpanCount.incrementAndGet();
            } else {
                this.waitWhenFull(maxQueueSize, spanLs, span);
            }
        }
    }

    private void waitWhenFull(int maxQueueSize, ConcurrentLinkedQueue<InnerSpan> spanLs, InnerSpan span) {
        if (Boolean.getBoolean(WAITWHENFULL_STR)) {
            while (totalSpanCount.get() >= maxQueueSize && Boolean.getBoolean(WAITWHENFULL_STR)) {
                LockSupport.parkNanos(30000000L);
            }
            spanLs.add(span);
            totalSpanCount.incrementAndGet();
        } else {
            int size = spanLs.size();
            totalSpanCount.addAndGet(-1 * size);
            log.warn("ZipkinInnerSpanReporter:list is full and trace_span lost " + size + " spans");
            discardCount.inc(size);
            spanLs.clear();
        }
    }

    static {
        for (int i = 0; i < 3; ++i) {
            Thread t = new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            SpanTask runnable;
                            if ((runnable = (SpanTask)queue.poll()) == null) {
                                continue;
                            }
                            runnable.run();
                        }
                    }
                    catch (Exception e) {
                        LockSupport.parkNanos(100000000L);
                        log.warn("ZipkinInnerSpanReporter: run task of trace_span exception ", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }, "ZipKinSpanTransport-" + i);
            t.setDaemon(true);
            t.start();
        }
        ThreadEndClear.addListener(threadidSet -> {
            ArrayList remove = new ArrayList();
            spanMaps.forEach((k, v) -> {
                if (v.isEmpty() && !threadidSet.contains(k)) {
                    remove.add(k);
                }
            });
            remove.forEach(k -> {
                spanMaps.remove(k);
                runnableMaps.remove(k);
            });
        });
    }

    class SpanTask
    implements Runnable {
        private long threadid;
        private List<Span> ls = new ArrayList<Span>(256);

        SpanTask(long threadid) {
            this.threadid = threadid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConcurrentLinkedQueue spanLs = (ConcurrentLinkedQueue)spanMaps.get(this.threadid);
            if (spanLs == null || spanLs.size() == 0) {
                return;
            }
            ConcurrentLinkedQueue concurrentLinkedQueue = spanLs;
            synchronized (concurrentLinkedQueue) {
                this.ls.clear();
                try {
                    InnerSpan innerspan;
                    for (int count = 0; count < 256 && (innerspan = (InnerSpan)spanLs.poll()) != null; ++count) {
                        this.ls.add(ZipkinInnerSpanReporter.this.convert(innerspan));
                    }
                }
                finally {
                    int size = this.ls.size();
                    if (size > 0) {
                        totalSpanCount.getAndAdd(-1 * size);
                        consumeCount.inc(size);
                        ZipkinInnerSpanReporter.this.reporter.report(this.ls.toArray(new Span[size]));
                    }
                }
            }
        }
    }
}

