/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.reporter.apicall;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import kd.bos.extension.ConcurrentHashSet;
import kd.bos.govern.GovernConfigs;
import kd.bos.govern.GovernDataType;
import kd.bos.govern.GovernPoJo;
import kd.bos.govern.StorageReporterFactory;
import kd.bos.govern.StorageType;
import kd.bos.thread.ThreadEndClear;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.InnerSpanReporter;
import kd.bos.trace.reporter.apicall.APICallData;
import kd.bos.trace.reporter.apicall.APIMetaData;
import kd.bos.util.async.SetQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APICallReporter
implements InnerSpanReporter {
    private static final Logger log = LoggerFactory.getLogger(APICallReporter.class);
    private static boolean STOP;
    private static Map<Long, ConcurrentLinkedQueue<APICallData>> apiDataMaps;
    private static Map<Long, APIDataReporterTask> runnableMaps;
    private static SetQueue<APIDataReporterTask> queue;
    private static AtomicInteger totalSpanCount;
    private static Set<String> apiMetadataSet;
    private static Queue<APIMetaData> metaQueue;
    private static AtomicInteger logWarnCount;
    private static volatile boolean startMetadataReportFlag;

    @Override
    public void report(InnerSpan span) {
        try {
            if (!GovernConfigs.getApicallEnable()) {
                STOP = true;
                return;
            }
            STOP = false;
            APICallData apiCallData = APICallReporter.spanConvertToApiBasicData(span);
            if (null == apiCallData) {
                return;
            }
            long threadId = Thread.currentThread().getId();
            ConcurrentLinkedQueue apiDataQueue = apiDataMaps.computeIfAbsent(threadId, key -> {
                runnableMaps.put(threadId, new APIDataReporterTask(threadId));
                return new ConcurrentLinkedQueue();
            });
            queue.putIfAbsent((Object)runnableMaps.get(threadId));
            int maxQueueSize = GovernConfigs.getReportQueueSize();
            if (totalSpanCount.get() < maxQueueSize) {
                apiDataQueue.add(apiCallData);
                totalSpanCount.incrementAndGet();
            } else {
                APICallReporter.waitWhenFull(maxQueueSize, apiDataQueue, apiCallData);
            }
        }
        catch (Exception e) {
            log.error("APICallReporter report failure,The errorMessage is :" + e.getMessage(), (Throwable)e);
        }
    }

    private static void waitWhenFull(int maxQueueSize, ConcurrentLinkedQueue<APICallData> apiDataQueue, APICallData apiCallData) {
        if (GovernConfigs.isWait()) {
            while (totalSpanCount.get() >= maxQueueSize && GovernConfigs.isWait()) {
                LockSupport.parkNanos(30000000L);
            }
            apiDataQueue.add(apiCallData);
            totalSpanCount.incrementAndGet();
        } else {
            int size = apiDataQueue.size();
            totalSpanCount.addAndGet(-1 * size);
            if (logWarnCount.incrementAndGet() == GovernConfigs.getReportLogWarnNum()) {
                log.warn("APICallReporter:list is full and trace_span lost " + size + " spans");
                logWarnCount.set(0);
            }
            apiDataQueue.clear();
        }
    }

    private static APICallData spanConvertToApiBasicData(InnerSpan span) {
        if (span == null) {
            return null;
        }
        Map<String, String> tagMap = span.tags();
        if (null == tagMap || !tagMap.containsKey("APICall.type")) {
            return null;
        }
        String signature = tagMap.get("APICall.signature");
        if (apiMetadataSet.size() <= GovernConfigs.getApiMetadataCacheLimit() && apiMetadataSet.add(signature)) {
            APIMetaData amd = new APIMetaData();
            amd.setType(tagMap.get("APICall.type"));
            amd.setServiceName(tagMap.get("APICall.serviceName"));
            amd.setMethodName(tagMap.get("APICall.methodName"));
            amd.setSignature(signature);
            amd.setAppId(tagMap.get("APICall.appId"));
            amd.setCloud(tagMap.get("APICall.cloud"));
            amd.setCollectionTime(Long.valueOf(tagMap.get("APICall.collectionTime")));
            metaQueue.offer(amd);
        }
        APICallData sr = new APICallData();
        sr.setType(tagMap.get("APICall.type"));
        sr.setTraceId(tagMap.get("APICall.traceId"));
        sr.setServiceName(tagMap.get("APICall.serviceName"));
        sr.setAppName(tagMap.get("APICall.appName"));
        sr.setDestInstance(tagMap.get("APICall.instanceId"));
        sr.setMethodName(tagMap.get("APICall.methodName"));
        sr.setSrcIp(tagMap.get("APICall.srcIp"));
        sr.setDestIp(tagMap.get("APICall.destIp"));
        sr.setSignature(signature);
        sr.setAppId(tagMap.get("APICall.appId"));
        sr.setCloud(tagMap.get("APICall.cloud"));
        sr.setCollectionTime(Long.valueOf(tagMap.get("APICall.collectionTime")));
        sr.setDurationMicros(Long.valueOf(String.valueOf(span.getAccumulatedMicros())));
        return sr;
    }

    static {
        apiDataMaps = new ConcurrentHashMap<Long, ConcurrentLinkedQueue<APICallData>>();
        runnableMaps = new ConcurrentHashMap<Long, APIDataReporterTask>();
        queue = new SetQueue();
        totalSpanCount = new AtomicInteger(0);
        apiMetadataSet = new ConcurrentHashSet();
        metaQueue = new ConcurrentLinkedQueue<APIMetaData>();
        logWarnCount = new AtomicInteger(0);
        startMetadataReportFlag = false;
        STOP = false;
        long reportStartTime = System.currentTimeMillis();
        for (int i = 0; i < GovernConfigs.getReportThreadNum(); ++i) {
            Thread t = new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            if (!startMetadataReportFlag && System.currentTimeMillis() - reportStartTime > (long)GovernConfigs.getApiMetadataReportWaitTime()) {
                                startMetadataReportFlag = true;
                            }
                            if (!STOP) {
                                APIDataReporterTask runnable = (APIDataReporterTask)queue.poll();
                                if (runnable != null) {
                                    runnable.run();
                                    continue;
                                }
                                TimeUnit.SECONDS.sleep(2L);
                                continue;
                            }
                            TimeUnit.SECONDS.sleep(30L);
                        }
                    }
                    catch (Exception e) {
                        log.warn("APIDataReporter: run task of trace_span exception ", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }, "APIDataReporter-poll-" + i);
            t.setDaemon(true);
            t.start();
        }
        ThreadEndClear.addListener(threadidSet -> {
            ArrayList remove = new ArrayList();
            apiDataMaps.forEach((k, v) -> {
                if (v.isEmpty() && !threadidSet.contains(k)) {
                    remove.add(k);
                }
            });
            remove.forEach(k -> {
                apiDataMaps.remove(k);
                runnableMaps.remove(k);
            });
        });
    }

    static class APIDataReporterTask
    implements Runnable {
        private long threadId;
        private int batchSize = GovernConfigs.getReportBatchSize();
        private List<GovernPoJo> list = new ArrayList<GovernPoJo>(this.batchSize);

        APIDataReporterTask(long threadId) {
            this.threadId = threadId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConcurrentLinkedQueue apiCallQueue = (ConcurrentLinkedQueue)apiDataMaps.get(this.threadId);
            if (apiCallQueue == null || apiCallQueue.size() == 0) {
                return;
            }
            ConcurrentLinkedQueue concurrentLinkedQueue = apiCallQueue;
            synchronized (concurrentLinkedQueue) {
                this.list.clear();
                try {
                    APICallData apiCallData;
                    for (int count = 0; count < this.batchSize && (apiCallData = (APICallData)apiCallQueue.poll()) != null; ++count) {
                        this.list.add(apiCallData);
                    }
                }
                finally {
                    int size = this.list.size();
                    if (size > 0) {
                        totalSpanCount.getAndAdd(-1 * size);
                        StorageReporterFactory.getStorageReporter(GovernDataType.API_CALL_DATA).reporter(this.list);
                    }
                    if (metaQueue.size() > 0 && startMetadataReportFlag && "true".equals(System.getProperty("isDBConfigured"))) {
                        StorageReporterFactory.getStorageReporter(GovernDataType.API_METADATA, StorageType.DB).reporter((GovernPoJo)metaQueue.poll());
                    }
                }
            }
        }
    }
}

