/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.reporter.sword;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.Log;
import kd.bos.trace.reporter.sword.SwordSpan;
import kd.bos.trace.reporter.zipkin.ConfiguredEndpointLocator;
import kd.bos.trace.reporter.zipkin.EndpointLocator;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Endpoint;
import zipkin.Span;

public class CovertSwardSpan {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final byte[] UNKNOWN_BYTES = "unknown".getBytes(UTF_8);
    private static final Set<String> START_EVENTS = new HashSet<String>(Arrays.asList("cr", "sr"));
    private static final EndpointLocator endpointLocator = new ConfiguredEndpointLocator();

    public static SwordSpan covert(InnerSpan innerSpan) {
        List binaryAnnotations;
        Span span = CovertSwardSpan.convert(innerSpan);
        SwordSpan.Builder builder = new SwordSpan.Builder();
        builder.traceId(TraceIdUtil.idToHex(span.traceId));
        builder.id(TraceIdUtil.idToHex(innerSpan.getSpanId()));
        if (span.parentId != null) {
            builder.parentId(TraceIdUtil.idToHex(span.parentId));
        }
        builder.crossNode(innerSpan.isCrossNode());
        builder.instanceId(innerSpan.getInstanceId());
        builder.name(span.name);
        builder.timestamp_millis(innerSpan.getBegin());
        if (!innerSpan.isRemote()) {
            if (!innerSpan.isRunning()) {
                builder.duration(CovertSwardSpan.calculateDurationInMicros(innerSpan));
            }
        } else {
            builder.duration(innerSpan.getAccumulatedMicros());
        }
        if ((binaryAnnotations = span.binaryAnnotations) != null) {
            HashMap<String, Object> tags = new HashMap<String, Object>(8);
            for (BinaryAnnotation binaryAnnotation : binaryAnnotations) {
                builder.serviceName(binaryAnnotation.endpoint.serviceName);
                tags.put(binaryAnnotation.key, new String(binaryAnnotation.value, StandardCharsets.UTF_8));
            }
            builder.tags(tags);
        }
        return builder.build();
    }

    private static Span convert(InnerSpan span) {
        Span.Builder zipkinSpan = Span.builder();
        Endpoint endpoint = endpointLocator.local();
        if (span.tags().containsKey("service")) {
            endpoint = endpoint.toBuilder().serviceName(span.tags().get("service")).build();
        }
        span.tag("ip", NetAddressUtils.getLocalIpAddress());
        CovertSwardSpan.processLogs(span, zipkinSpan, endpoint);
        CovertSwardSpan.addZipkinAnnotations(zipkinSpan, span, endpoint);
        CovertSwardSpan.addZipkinBinaryAnnotations(zipkinSpan, span, endpoint);
        if (!span.isRemote()) {
            zipkinSpan.timestamp(Long.valueOf(span.getBegin() * 1000L));
            if (!span.isRunning()) {
                zipkinSpan.duration(Long.valueOf(CovertSwardSpan.calculateDurationInMicros(span)));
            }
        }
        zipkinSpan.traceIdHigh(span.getTraceIdHigh());
        zipkinSpan.traceId(span.getTraceId());
        if (span.getParents().size() > 0) {
            zipkinSpan.parentId(span.getParents().get(0));
        }
        zipkinSpan.id(span.getSpanId());
        if (StringUtils.isNotEmpty((String)span.getName())) {
            zipkinSpan.name(span.getName());
        }
        return zipkinSpan.build();
    }

    private static void ensureLocalComponent(InnerSpan span, Span.Builder zipkinSpan, Endpoint localEndpoint) {
        if (span.tags().containsKey("lc")) {
            return;
        }
        byte[] processId = span.getProcessId() != null ? span.getProcessId().toLowerCase().getBytes(UTF_8) : UNKNOWN_BYTES;
        BinaryAnnotation component = BinaryAnnotation.builder().type(BinaryAnnotation.Type.STRING).key("lc").value(processId).endpoint(localEndpoint).build();
        zipkinSpan.addBinaryAnnotation(component);
    }

    private static void ensureServerAddr(InnerSpan span, Span.Builder zipkinSpan, Endpoint localEndpoint) {
        if (span.tags().containsKey("peer.service")) {
            zipkinSpan.addBinaryAnnotation(BinaryAnnotation.address((String)"sa", (Endpoint)localEndpoint.toBuilder().serviceName(span.tags().get("peer.service")).build()));
        }
    }

    private static void processLogs(InnerSpan span, Span.Builder zipkinSpan, Endpoint endpoint) {
        boolean notClientOrServer = true;
        boolean hasClientSend = false;
        for (Log log : span.logs()) {
            if (START_EVENTS.contains(log.getEvent())) {
                notClientOrServer = false;
            }
            if (!"cs".equals(log.getEvent())) continue;
            hasClientSend = !span.tags().containsKey("sa");
        }
        if (notClientOrServer) {
            CovertSwardSpan.ensureLocalComponent(span, zipkinSpan, endpoint);
        }
        if (hasClientSend) {
            CovertSwardSpan.ensureServerAddr(span, zipkinSpan, endpoint);
        }
    }

    private static void addZipkinAnnotations(Span.Builder zipkinSpan, InnerSpan span, Endpoint endpoint) {
        for (Log ta : span.logs()) {
            Annotation zipkinAnnotation = Annotation.builder().endpoint(endpoint).timestamp(ta.getTimestamp() * 1000L).value(ta.getEvent()).build();
            zipkinSpan.addAnnotation(zipkinAnnotation);
        }
    }

    private static void addZipkinBinaryAnnotations(Span.Builder zipkinSpan, InnerSpan span, Endpoint ep) {
        for (Map.Entry<String, String> e : span.tags().entrySet()) {
            CovertSwardSpan.addZipkinBinaryAnnotation(e.getKey(), e.getValue(), ep, zipkinSpan);
        }
    }

    private static void addZipkinBinaryAnnotation(String key, String value, Endpoint ep, Span.Builder zipkinSpan) {
        BinaryAnnotation binaryAnn = BinaryAnnotation.builder().type(BinaryAnnotation.Type.STRING).key(key).value(value.getBytes(UTF_8)).endpoint(ep).build();
        zipkinSpan.addBinaryAnnotation(binaryAnn);
    }

    private static long calculateDurationInMicros(InnerSpan span) {
        Log clientSend = CovertSwardSpan.hasLog("cs", span);
        Log clientReceived = CovertSwardSpan.hasLog("cr", span);
        if (clientSend != null && clientReceived != null) {
            return (clientReceived.getTimestamp() - clientSend.getTimestamp()) * 1000L;
        }
        return span.getAccumulatedMicros();
    }

    private static Log hasLog(String logName, InnerSpan span) {
        for (Log log : span.logs()) {
            if (!logName.equals(log.getEvent())) continue;
            return log;
        }
        return null;
    }
}

