/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.reporter.sword;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import kd.bos.govern.GovernConfigs;
import kd.bos.thread.ThreadEndClear;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.InnerSpanReporter;
import kd.bos.trace.reporter.sword.kafka.TracerKafkaReport;
import kd.bos.trace.reporter.sword.standard.TracerStandardReport;
import kd.bos.util.async.SetQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwordReport
implements InnerSpanReporter {
    private static final Logger log = LoggerFactory.getLogger(SwordReport.class);
    private static boolean STOP;
    private static Map<Long, ConcurrentLinkedQueue<InnerSpan>> spanMaps;
    private static Map<Long, RunnerTask> runnableMaps;
    private static SetQueue<RunnerTask> queue;
    private static AtomicInteger totalSpanCount;
    private static AtomicInteger logWarnCount;

    private static boolean isOpen() {
        return Boolean.getBoolean("gov.trace.enable");
    }

    @Override
    public void report(InnerSpan span) {
        try {
            if (!span.isExportable()) {
                return;
            }
            long threadId = Thread.currentThread().getId();
            ConcurrentLinkedQueue apiDataQueue = spanMaps.computeIfAbsent(threadId, key -> {
                runnableMaps.put(threadId, new RunnerTask(threadId));
                return new ConcurrentLinkedQueue();
            });
            queue.putIfAbsent((Object)runnableMaps.get(threadId));
            int maxQueueSize = GovernConfigs.getReportQueueSize();
            if (totalSpanCount.get() < maxQueueSize) {
                apiDataQueue.add(span);
                totalSpanCount.incrementAndGet();
            } else {
                this.waitWhenFull(maxQueueSize, apiDataQueue, span);
            }
        }
        catch (Exception e) {
            log.error("SwordReport report failure,The errorMessage is :" + e.getMessage(), (Throwable)e);
        }
    }

    private void waitWhenFull(int maxQueueSize, ConcurrentLinkedQueue<InnerSpan> spanQueue, InnerSpan apiCallData) {
        if (GovernConfigs.isWait()) {
            while (totalSpanCount.get() >= maxQueueSize && GovernConfigs.isWait()) {
                LockSupport.parkNanos(30000000L);
            }
            spanQueue.add(apiCallData);
            totalSpanCount.incrementAndGet();
        } else {
            int size = spanQueue.size();
            totalSpanCount.addAndGet(-1 * size);
            if (logWarnCount.incrementAndGet() == GovernConfigs.getReportLogWarnNum()) {
                log.warn("SwordReport:list is full and trace_span lost " + size + " spans");
                logWarnCount.set(0);
            }
            spanQueue.clear();
        }
    }

    static {
        spanMaps = new ConcurrentHashMap<Long, ConcurrentLinkedQueue<InnerSpan>>();
        runnableMaps = new ConcurrentHashMap<Long, RunnerTask>();
        queue = new SetQueue();
        totalSpanCount = new AtomicInteger(0);
        logWarnCount = new AtomicInteger(0);
        STOP = false;
        for (int i = 0; i < 3; ++i) {
            Thread t = new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            if (SwordReport.isOpen()) {
                                RunnerTask runnable = (RunnerTask)queue.poll();
                                if (runnable != null) {
                                    runnable.run();
                                    continue;
                                }
                                TimeUnit.SECONDS.sleep(2L);
                                continue;
                            }
                            TimeUnit.SECONDS.sleep(30L);
                        }
                    }
                    catch (Exception e) {
                        log.warn("SwordReport: run task of trace_span exception ", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }, "SwordReport-poll-" + i);
            t.setDaemon(true);
            t.start();
        }
        ThreadEndClear.addListener(threadidSet -> {
            ArrayList remove = new ArrayList();
            spanMaps.forEach((k, v) -> {
                if (v.isEmpty() && !threadidSet.contains(k)) {
                    remove.add(k);
                }
            });
            remove.forEach(k -> {
                spanMaps.remove(k);
                runnableMaps.remove(k);
            });
        });
    }

    static class RunnerTask
    implements Runnable {
        private long threadId;
        private int batchSize = 1000;
        private List<InnerSpan> list = new ArrayList<InnerSpan>(this.batchSize);

        RunnerTask(long threadId) {
            this.threadId = threadId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean isKafka = Boolean.getBoolean("trace.reporter.sword.kafka.enable");
            boolean isVip = Boolean.getBoolean("trace.reporter.sword.vip.enable");
            ConcurrentLinkedQueue queue = (ConcurrentLinkedQueue)spanMaps.get(this.threadId);
            if (queue == null || queue.size() == 0) {
                return;
            }
            ConcurrentLinkedQueue concurrentLinkedQueue = queue;
            synchronized (concurrentLinkedQueue) {
                this.list.clear();
                try {
                    InnerSpan innerSpan;
                    for (int count = 0; count < this.batchSize && (innerSpan = (InnerSpan)queue.poll()) != null; ++count) {
                        if (this.isReportByTimeFilter(innerSpan)) {
                            totalSpanCount.decrementAndGet();
                            continue;
                        }
                        this.list.add(innerSpan);
                    }
                }
                finally {
                    int size = this.list.size();
                    if (size > 0) {
                        totalSpanCount.getAndAdd(-1 * size);
                        if (isKafka || isVip) {
                            TracerKafkaReport.send(this.list);
                        } else {
                            TracerStandardReport.send(this.list);
                        }
                    }
                }
            }
        }

        boolean isReportByTimeFilter(InnerSpan innerSpan) {
            if (Boolean.parseBoolean(System.getProperty("gov.report.filter.time.enable", "true"))) {
                long filterTime = Integer.getInteger("gov.report.filter.time", 1000).intValue();
                return innerSpan.getDurationMicros() < filterTime;
            }
            return false;
        }
    }
}

