/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.reporter.topology;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import kd.bos.govern.GovernConfigs;
import kd.bos.govern.GovernDataType;
import kd.bos.govern.GovernPoJo;
import kd.bos.govern.StorageReporterFactory;
import kd.bos.thread.ThreadEndClear;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.InnerSpanReporter;
import kd.bos.trace.reporter.topology.TopologyData;
import kd.bos.trace.reporter.topology.TopologyServiceData;
import kd.bos.util.async.SetQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyReporter
implements InnerSpanReporter {
    private static final Logger log = LoggerFactory.getLogger(TopologyReporter.class);
    private static boolean STOP;
    private static Map<Long, ConcurrentLinkedQueue<TopologyData>> topologyMaps;
    private static Map<Long, TopologyReporterTask> runnableMaps;
    private static SetQueue<TopologyReporterTask> queue;
    private static AtomicInteger totalSpanCount;
    private static AtomicInteger logWarnCount;

    private static void waitWhenFull(int maxQueueSize, ConcurrentLinkedQueue<TopologyData> topologyQueue, TopologyData topology) {
        if (GovernConfigs.isWait()) {
            while (totalSpanCount.get() >= maxQueueSize && GovernConfigs.isWait()) {
                LockSupport.parkNanos(30000000L);
            }
            topologyQueue.add(topology);
            totalSpanCount.incrementAndGet();
        } else {
            int size = topologyQueue.size();
            totalSpanCount.addAndGet(-1 * size);
            if (logWarnCount.incrementAndGet() == GovernConfigs.getReportLogWarnNum()) {
                log.warn("APICallReporter:list is full and trace_span lost " + size + " spans");
                logWarnCount.set(0);
            }
            topologyQueue.clear();
        }
    }

    private static TopologyData spanConvertToTopologyData(InnerSpan span) {
        if (span == null) {
            return null;
        }
        Map<String, String> tagMap = span.tags();
        if (null == tagMap || !tagMap.containsKey("topology.srcService")) {
            return null;
        }
        String destComponent = tagMap.get("topology.destComponent");
        String protocol2 = tagMap.get("topology.protocol");
        TopologyServiceData sr = new TopologyServiceData();
        sr.setSrcService(tagMap.get("topology.srcService"));
        sr.setDestComponent(destComponent);
        sr.setSrcServiceType("MService");
        if (!(protocol2.equals("dubbo") || protocol2.equals("feign") || protocol2.equals("http"))) {
            sr.setDestService(tagMap.get("topology.destComponent"));
            sr.setDestServiceInstanceId(tagMap.get("topology.descService"));
            sr.setDestServiceType("component");
        } else {
            sr.setDestServiceInstanceId(tagMap.get("topology.descServiceInstanceId"));
            sr.setDestService(tagMap.get("topology.descService"));
            sr.setDestServiceType("MService");
        }
        sr.setProtocol(protocol2);
        sr.setSrcAppId(tagMap.get("topology.srcAppId"));
        sr.setDescAppId(tagMap.get("topology.descAppId"));
        sr.setSrcServiceInstanceId(tagMap.get("topology.srcServiceInstanceId"));
        sr.setTimestamp(Long.valueOf(tagMap.get("topology.timestamp")));
        sr.setDurationMicros(Long.valueOf(String.valueOf(span.getAccumulatedMicros())));
        sr.setTraceId(span.traceIdString());
        return sr;
    }

    @Override
    public void report(InnerSpan span) {
        try {
            if (!GovernConfigs.getTopologyEnable()) {
                STOP = true;
                return;
            }
            STOP = false;
            TopologyData topology = TopologyReporter.spanConvertToTopologyData(span);
            if (null == topology) {
                return;
            }
            long threadId = Thread.currentThread().getId();
            ConcurrentLinkedQueue topologyQueue = topologyMaps.computeIfAbsent(threadId, key -> {
                runnableMaps.put(threadId, new TopologyReporterTask(threadId));
                return new ConcurrentLinkedQueue();
            });
            queue.putIfAbsent((Object)runnableMaps.get(threadId));
            int maxQueueSize = GovernConfigs.getReportQueueSize();
            if (totalSpanCount.get() < maxQueueSize) {
                topologyQueue.add(topology);
                totalSpanCount.incrementAndGet();
            } else {
                TopologyReporter.waitWhenFull(maxQueueSize, topologyQueue, topology);
            }
        }
        catch (Exception e) {
            log.error("TopologyReporter report failure,The errorMessage is: " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        topologyMaps = new ConcurrentHashMap<Long, ConcurrentLinkedQueue<TopologyData>>();
        runnableMaps = new ConcurrentHashMap<Long, TopologyReporterTask>();
        queue = new SetQueue();
        totalSpanCount = new AtomicInteger(0);
        logWarnCount = new AtomicInteger(0);
        STOP = false;
        for (int i = 0; i < GovernConfigs.getReportThreadNum(); ++i) {
            Thread t = new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            if (!STOP) {
                                TopologyReporterTask runnable = (TopologyReporterTask)queue.poll();
                                if (runnable != null) {
                                    runnable.run();
                                    continue;
                                }
                                TimeUnit.SECONDS.sleep(2L);
                                continue;
                            }
                            TimeUnit.SECONDS.sleep(30L);
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }, "TopologyReporter-pull-" + i);
            t.setDaemon(true);
            t.start();
        }
        ThreadEndClear.addListener(threadidSet -> {
            ArrayList remove = new ArrayList();
            topologyMaps.forEach((k, v) -> {
                if (v.isEmpty() && !threadidSet.contains(k)) {
                    remove.add(k);
                }
            });
            remove.forEach(k -> {
                topologyMaps.remove(k);
                runnableMaps.remove(k);
            });
        });
    }

    static class TopologyReporterTask
    implements Runnable {
        private long threadid;
        private int batchSize = GovernConfigs.getReportBatchSize();
        private List<GovernPoJo> list = new ArrayList<GovernPoJo>(this.batchSize);

        TopologyReporterTask(long threadid) {
            this.threadid = threadid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConcurrentLinkedQueue topologyQueue = (ConcurrentLinkedQueue)topologyMaps.get(this.threadid);
            if (topologyQueue == null || topologyQueue.size() == 0) {
                return;
            }
            ConcurrentLinkedQueue concurrentLinkedQueue = topologyQueue;
            synchronized (concurrentLinkedQueue) {
                this.list.clear();
                try {
                    TopologyData topology;
                    for (int count = 0; count < this.batchSize && (topology = (TopologyData)topologyQueue.poll()) != null; ++count) {
                        this.list.add(topology);
                    }
                }
                finally {
                    int size = this.list.size();
                    if (size > 0) {
                        totalSpanCount.getAndAdd(-1 * size);
                        StorageReporterFactory.getStorageReporter(GovernDataType.TOPOLOGY_DATA).reporter(this.list);
                    }
                }
            }
        }
    }
}

