/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.reporter.topology;

import kd.bos.govern.GovernConfigs;
import kd.bos.instance.Instance;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.tracer.TraceSpanImpl;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;

public class TopologyTagInject {
    public static void setMserviceTag(InnerSpan newSpan, String descService, String protocol2, String descServiceInstanceId, String destAppId) {
        if (!GovernConfigs.getTopologyEnable()) {
            return;
        }
        TraceSpanImpl traceSpan = TraceSpanImpl.getCurrent();
        if (newSpan == null) {
            if (traceSpan == null) {
                return;
            }
            newSpan = TopologyTagInject.creatSpan(traceSpan, "MserviceTopology");
            traceSpan.setGovernSpan(newSpan);
        }
        newSpan.tag("topology.srcService", Instance.getAppName());
        newSpan.tag("topology.descService", descService);
        newSpan.tag("topology.destComponent", "MService");
        newSpan.tag("topology.protocol", protocol2);
        newSpan.tag("topology.srcServiceInstanceId", Instance.getInstanceId());
        newSpan.tag("topology.descServiceInstanceId", descServiceInstanceId);
        newSpan.tag("topology.descAppId", destAppId);
        newSpan.tag("topology.timestamp", Long.toString(System.currentTimeMillis()));
    }

    public static void setCompentTag(InnerSpan newSpan, String destService, String destComponent, String protocol2) {
        if (!GovernConfigs.getTopologyEnable()) {
            return;
        }
        TraceSpanImpl traceSpan = TraceSpanImpl.getCurrent();
        if (newSpan == null) {
            if (traceSpan == null) {
                return;
            }
            newSpan = TopologyTagInject.creatSpan(traceSpan, "ComponentTopology");
            traceSpan.setGovernSpan(newSpan);
        }
        newSpan.tag("topology.srcService", Instance.getAppName());
        newSpan.tag("topology.descService", destService);
        newSpan.tag("topology.destComponent", destComponent);
        newSpan.tag("topology.srcServiceInstanceId", Instance.getInstanceId());
        newSpan.tag("topology.descServiceInstanceId", "");
        newSpan.tag("topology.protocol", protocol2);
        newSpan.tag("topology.timestamp", Long.toString(System.currentTimeMillis()));
    }

    public static void setWebTag(InnerSpan newSpan, String srcService, String appId) {
        if (!GovernConfigs.getTopologyEnable()) {
            return;
        }
        TraceSpanImpl traceSpan = TraceSpanImpl.getCurrent();
        if (newSpan == null) {
            if (traceSpan == null) {
                return;
            }
            newSpan = TopologyTagInject.creatSpan(traceSpan, "WebTopology");
            traceSpan.setGovernSpan(newSpan);
        }
        newSpan.tag("topology.srcService", srcService);
        newSpan.tag("topology.srcServiceInstanceId", srcService);
        newSpan.tag("topology.descService", Instance.getAppName());
        newSpan.tag("topology.descServiceInstanceId", Instance.getInstanceId());
        newSpan.tag("topology.destComponent", "MService");
        newSpan.tag("topology.protocol", "http");
        newSpan.tag("topology.descAppId", appId);
        newSpan.tag("topology.timestamp", Long.toString(System.currentTimeMillis()));
    }

    public static String getClient(String clientType) {
        return StringUtils.isEmpty((String)clientType) ? "User-web" : "User-" + clientType;
    }

    private static InnerSpan creatSpan(TraceSpanImpl traceSpan, String spanName) {
        InnerSpan innerSpan = traceSpan.getGovernSpan();
        if (innerSpan != null) {
            return innerSpan;
        }
        long traceId = TraceIdUtil.createId();
        return InnerSpan.builder().name(spanName).traceId(traceId).spanId(traceId).begin(traceSpan.getStartTime()).isCrossNode(false).build();
    }
}

