/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.reporter.zipkin.http;

import java.io.IOException;
import java.util.List;
import kd.bos.trace.reporter.zipkin.http.HttpTemplate;
import zipkin.Component;
import zipkin.reporter.BytesMessageEncoder;
import zipkin.reporter.Callback;
import zipkin.reporter.Encoding;
import zipkin.reporter.Sender;

public final class HttpSender
implements Sender {
    private final HttpTemplate httpTemplate;
    private transient boolean closeCalled;

    public HttpSender(HttpTemplate httpTemplate) {
        this.httpTemplate = httpTemplate;
    }

    public Encoding encoding() {
        return Encoding.JSON;
    }

    public int messageMaxBytes() {
        return 0x500000;
    }

    public int messageSizeInBytes(List<byte[]> spans) {
        return this.encoding().listSizeInBytes(spans);
    }

    public void sendSpans(List<byte[]> encodedSpans, Callback callback) {
        if (this.closeCalled) {
            throw new IllegalStateException("close");
        }
        try {
            byte[] message = BytesMessageEncoder.JSON.encode(encodedSpans);
            this.post(message);
            callback.onComplete();
        }
        catch (Exception e) {
            callback.onError((Throwable)e);
        }
        catch (Error e) {
            callback.onError((Throwable)e);
            throw e;
        }
    }

    public Component.CheckResult check() {
        try {
            this.post(new byte[]{91, 93});
            return Component.CheckResult.OK;
        }
        catch (Exception e) {
            return Component.CheckResult.failed((Exception)e);
        }
    }

    public void close() {
        this.closeCalled = true;
    }

    void post(byte[] json) throws IOException {
        this.httpTemplate.post(json, "application/json");
    }
}

