/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.sampler;

import java.security.SecureRandom;
import java.util.BitSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.Sampler;
import kd.bos.trace.sampler.SamplerProperties;

public class PercentageBasedSampler
implements Sampler {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final BitSet sampleDecisions;
    private final SamplerProperties configuration;

    public PercentageBasedSampler(SamplerProperties configuration) {
        int outOf100 = (int)(configuration.getPercentage() * 100.0f);
        this.sampleDecisions = PercentageBasedSampler.randomBitSet(100, outOf100, new SecureRandom());
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSampled(InnerSpan currentSpan) {
        if (this.configuration.getPercentage() == 0.0f || currentSpan == null) {
            return false;
        }
        if (this.configuration.getPercentage() == 100.0f) {
            return true;
        }
        PercentageBasedSampler percentageBasedSampler = this;
        synchronized (percentageBasedSampler) {
            int i = this.counter.getAndIncrement();
            boolean result = this.sampleDecisions.get(i);
            if (i == 99) {
                this.counter.set(0);
            }
            return result;
        }
    }

    static BitSet randomBitSet(int size, int cardinality, Random rnd) {
        int i;
        BitSet result = new BitSet(size);
        int[] chosen = new int[cardinality];
        for (i = 0; i < cardinality; ++i) {
            chosen[i] = i;
            result.set(i);
        }
        while (i < size) {
            int j = rnd.nextInt(i + 1);
            if (j < cardinality) {
                result.clear(chosen[j]);
                result.set(i);
                chosen[j] = i;
            }
            ++i;
        }
        return result;
    }
}

