/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.tracer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlowConfig {
    private static Logger logger = LoggerFactory.getLogger(SlowConfig.class);
    private static Properties prop = new Properties();

    private static void load() {
        InputStream in = null;
        try {
            in = SlowConfig.class.getResourceAsStream("/kd/bos/trace/slow.properties");
            prop.load(in);
        }
        catch (Exception e) {
            logger.warn("SlowConfig.load error:" + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.warn("SlowConfig.load error:" + e.getMessage());
                }
            }
        }
    }

    public static int getSlowTime(String type) {
        String key = "trace." + type + ".slow";
        return SlowConfig.getIntByKey(key);
    }

    private static int getIntByKey(String key) {
        String s = System.getProperty(key);
        if (s == null) {
            s = prop.getProperty(key);
        }
        if (s != null) {
            try {
                return Integer.parseInt(s.trim());
            }
            catch (Exception e) {
                logger.warn("SlowConfig.getIntByKey error:" + e.getMessage());
            }
        }
        return Integer.MAX_VALUE;
    }

    static {
        SlowConfig.load();
    }
}

