/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.tracer;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bundle.Resources;
import kd.bos.thread.ThreadLocalUtils;
import kd.bos.util.ThreadLocals;

public class TraceStatistics {
    private static final String EMPTY_STR = "";
    private static final String BOS_APM = "bos-apm";
    private static ThreadLocal<Map<String, Info>> l = ThreadLocals.create(() -> new HashMap());

    public static void statistic(String type, long timestap) {
        Map<String, Info> m = l.get();
        if (!m.containsKey(type)) {
            m.put(type, new Info(type));
        }
        Info info = m.get(type);
        info.counts++;
        Info info2 = info;
        info2.totalTimestap = info2.totalTimestap + timestap;
    }

    public static void statisticCustomItem(String type, String key, long value) {
        Map<String, Info> m = l.get();
        if (!m.containsKey(type)) {
            m.put(type, new Info(type));
        }
        Info info = m.get(type);
        info.addCustomStatisticsItem(key, value);
    }

    public static String getThreadTraceStatistic(Thread t) {
        try {
            Map info = (Map)ThreadLocalUtils.getThreadLocalValue((Thread)t, l);
            if (info == null) {
                return EMPTY_STR;
            }
            StringBuilder sb = new StringBuilder();
            info.forEach((k, v) -> {
                String stat = String.format(Resources.get((String)BOS_APM, (String)"TraceStatistics_0", (String)"%1$s : Number of executions: %2$s , total time: %3$s milliseconds, average time: %4$s milliseconds<br>", (Object[])new Object[0]), ((Info)v).type, ((Info)v).counts, ((Info)v).totalTimestap, new BigDecimal(((Info)v).totalTimestap + EMPTY_STR).divide(new BigDecimal(((Info)v).counts + EMPTY_STR), 2, RoundingMode.HALF_UP));
                sb.append(stat);
                String infoCustomStatistics = v.getCustomStatistics();
                if (infoCustomStatistics.length() > 0) {
                    sb.append(infoCustomStatistics);
                }
            });
            return sb.toString();
        }
        catch (Exception e) {
            return EMPTY_STR;
        }
    }

    public static List<ThreadTraceStat> getThreadTraceStatisticInfo(Thread t) {
        try {
            Map info = (Map)ThreadLocalUtils.getThreadLocalValue((Thread)t, l);
            if (info == null) {
                return Collections.emptyList();
            }
            ArrayList<ThreadTraceStat> statList = new ArrayList<ThreadTraceStat>();
            info.forEach((k, v) -> {
                ThreadTraceStat threadTraceStat = new ThreadTraceStat();
                threadTraceStat.setType(((Info)v).type);
                threadTraceStat.setExecCount(((Info)v).counts);
                threadTraceStat.setTotalDuration(((Info)v).totalTimestap);
                threadTraceStat.setAvgDuration(((Info)v).totalTimestap / (long)((Info)v).counts);
                threadTraceStat.setCustomExtendStatictics(v.getCustomStatistics());
                statList.add(threadTraceStat);
            });
            return statList;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static class ThreadTraceStat {
        private String type;
        private int execCount;
        private long totalDuration;
        private long avgDuration;
        private String customExtendStatictics;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getExecCount() {
            return this.execCount;
        }

        public void setExecCount(int execCount) {
            this.execCount = execCount;
        }

        public long getTotalDuration() {
            return this.totalDuration;
        }

        public void setTotalDuration(long totalDuration) {
            this.totalDuration = totalDuration;
        }

        public long getAvgDuration() {
            return this.avgDuration;
        }

        public void setAvgDuration(long avgDuration) {
            this.avgDuration = avgDuration;
        }

        public String getCustomExtendStatictics() {
            return this.customExtendStatictics;
        }

        public void setCustomExtendStatictics(String customExtendStatictics) {
            this.customExtendStatictics = customExtendStatictics;
        }
    }

    static class Info {
        private String type;
        private int counts = 0;
        private long totalTimestap = 0L;
        private Map<String, List<Long>> customStatisticsMap;

        private Info(String type) {
            this.type = type;
        }

        public String getCustomStatistics() {
            if (this.customStatisticsMap == null || this.customStatisticsMap.isEmpty()) {
                return TraceStatistics.EMPTY_STR;
            }
            StringBuilder sb = new StringBuilder();
            this.customStatisticsMap.forEach((k, v) -> {
                sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[").append((String)k).append("] ");
                int count = v.size();
                if (count == 0) {
                    return;
                }
                long total = 0L;
                long max = -1L;
                long min = Long.MAX_VALUE;
                long avg = 0L;
                for (int i = 0; i < count; ++i) {
                    long cur = (Long)v.get(i);
                    total += cur;
                    if (max < cur) {
                        max = cur;
                    }
                    if (min <= cur) continue;
                    min = cur;
                }
                avg = total / (long)count;
                sb.append("count:").append(count).append(",max:").append(max).append(",min:").append(min).append(",avg:").append(avg).append("<br/> ");
            });
            return sb.toString();
        }

        public void addCustomStatisticsItem(String key, long value) {
            if (this.customStatisticsMap == null) {
                this.customStatisticsMap = new HashMap<String, List<Long>>(2);
            }
            List ls = this.customStatisticsMap.computeIfAbsent(key, k -> new ArrayList(2));
            ls.add(value);
        }
    }
}

