/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.util;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import kd.bos.trace.util.InetUtilsProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InetUtils {
    public static final InetUtils instance = new InetUtils(new InetUtilsProperties());
    private static Logger logger = LoggerFactory.getLogger(InetUtils.class);
    private final InetUtilsProperties properties;
    private HostInfo firstNonLoopbackHostInfo = null;

    public InetUtils(InetUtilsProperties properties) {
        this.properties = properties;
    }

    public static HostInfo getFirstNonLoopbackHostInfo() {
        return instance.findFirstNonLoopbackHostInfo();
    }

    public static HostInfo convert(InetAddress address) {
        return instance.convertAddress(address);
    }

    public static int getIpAddressAsInt(String host) {
        return new HostInfo(host).getIpAddressAsInt();
    }

    public void close() {
    }

    public HostInfo findFirstNonLoopbackHostInfo() {
        if (this.firstNonLoopbackHostInfo != null) {
            return this.firstNonLoopbackHostInfo;
        }
        InetAddress address = this.findFirstNonLoopbackAddress();
        if (address != null) {
            this.firstNonLoopbackHostInfo = this.convertAddress(address);
        }
        HostInfo hostInfo = new HostInfo();
        hostInfo.setHostname(this.properties.getDefaultHostname());
        hostInfo.setIpAddress(this.properties.getDefaultIpAddress());
        this.firstNonLoopbackHostInfo = hostInfo;
        return this.firstNonLoopbackHostInfo;
    }

    public InetAddress findFirstNonLoopbackAddress() {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp() || ifc.getIndex() >= lowest && result != null) continue;
                lowest = ifc.getIndex();
                result = this.getInetAddress(ifc, result);
            }
        }
        catch (IOException ex) {
            logger.warn("Cannot get first non-loopback address", (Throwable)ex);
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            logger.warn("Unable to retrieve localhost");
            return null;
        }
    }

    private InetAddress getInetAddress(NetworkInterface ifc, InetAddress result) {
        if (!this.ignoreInterface(ifc.getDisplayName())) {
            Enumeration<InetAddress> addrs = ifc.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress address = addrs.nextElement();
                if (!(address instanceof Inet4Address) || address.isLoopbackAddress() || this.ignoreAddress(address)) continue;
                result = address;
            }
        }
        return result;
    }

    boolean ignoreAddress(InetAddress address) {
        if (this.properties.isUseOnlySiteLocalInterfaces() && !address.isSiteLocalAddress()) {
            return true;
        }
        for (String regex : this.properties.getPreferredNetworks()) {
            if (address.getHostAddress().matches(regex) || address.getHostAddress().startsWith(regex)) continue;
            return true;
        }
        return false;
    }

    boolean ignoreInterface(String interfaceName) {
        for (String regex : this.properties.getIgnoredInterfaces()) {
            if (!interfaceName.matches(regex)) continue;
            return true;
        }
        return false;
    }

    public HostInfo convertAddress(InetAddress address) {
        HostInfo hostInfo = new HostInfo();
        String hostname = null;
        try {
            hostname = address.getHostName();
        }
        catch (Exception e) {
            hostname = "localhost";
        }
        hostInfo.setHostname(hostname);
        hostInfo.setIpAddress(address.getHostAddress());
        return hostInfo;
    }

    public static class HostInfo {
        private boolean override;
        private String ipAddress;
        private String hostname;

        public HostInfo(String hostname) {
            this.hostname = hostname;
        }

        public HostInfo() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HostInfo)) {
                return false;
            }
            HostInfo other = (HostInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isOverride() != other.isOverride()) {
                return false;
            }
            String this$ipAddress = this.getIpAddress();
            String other$ipAddress = other.getIpAddress();
            if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                return false;
            }
            String this$hostname = this.getHostname();
            String other$hostname = other.getHostname();
            return this$hostname == null ? other$hostname == null : this$hostname.equals(other$hostname);
        }

        protected boolean canEqual(Object other) {
            return other instanceof HostInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOverride() ? 79 : 97);
            String $ipAddress = this.getIpAddress();
            result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
            String $hostname = this.getHostname();
            result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
            return result;
        }

        public String toString() {
            return "InetUtils.HostInfo(override=" + this.isOverride() + ", ipAddress=" + this.getIpAddress() + ", hostname=" + this.getHostname() + ")";
        }

        public boolean isOverride() {
            return this.override;
        }

        public void setOverride(boolean override) {
            this.override = override;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public int getIpAddressAsInt() {
            InetAddress inetAddress = null;
            String host = this.ipAddress;
            if (host == null) {
                host = this.hostname;
            }
            try {
                inetAddress = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
            return ByteBuffer.wrap(inetAddress.getAddress()).getInt();
        }
    }
}

