/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.util;

import java.security.SecureRandom;
import java.util.Random;
import kd.bos.thread.SetThreadName;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceIdUtil {
    private static final Logger log = LoggerFactory.getLogger(TraceIdUtil.class);
    public static final String traceIdLogEnable = "gov.trace.traceid.log.enable";
    private static Random random = new SecureRandom();
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static long createId() {
        return random.nextLong();
    }

    public static long createTraceId() {
        long id = TraceIdUtil.createId();
        ThreadTruck.put((Object)"apm.traceid", (Object)id);
        String traceId = TraceIdUtil.idToHex(id);
        ThreadTruck.put((Object)"apm.traceid.string", (Object)traceId);
        return id;
    }

    public static String createTraceIdString() {
        String currentThreadName = Thread.currentThread().getName();
        if (currentThreadName.contains("RpcRequest") && ThreadTruck.get((Object)"apm.traceid.string") != null) {
            if (Boolean.getBoolean(traceIdLogEnable)) {
                log.warn("\u5f53\u524dRpc\u8bf7\u6c42TraceId\u4e3a {},\u5f53\u524dRpc\u8bf7\u6c42\u5df2\u7ecf\u5b58\u5728TraceId\uff0c\u4e0d\u5141\u8bb8\u518d\u4fee\u6539\uff0c\u4fee\u6539\u5806\u6808\u4e3a\uff1a", ThreadTruck.get((Object)"apm.traceid.string"), (Object)new Exception());
            }
            return (String)ThreadTruck.get((Object)"apm.traceid.string");
        }
        long id = TraceIdUtil.createTraceId();
        return TraceIdUtil.idToHex(id);
    }

    public static void setCurrentTraceId(String traceId) {
        ThreadTruck.put((Object)"apm.traceid.string", (Object)traceId);
        SetThreadName.setTraceId((String)traceId);
    }

    public static long getCurrentTraceId() {
        String traceId;
        Long L = (Long)ThreadTruck.get((Object)"apm.traceid");
        if (L == null && StringUtils.isNotEmpty((String)(traceId = (String)ThreadTruck.get((Object)"apm.traceid.string")))) {
            L = TraceIdUtil.hexToId(traceId);
            ThreadTruck.put((Object)"apm.traceid", (Object)L);
        }
        return L == null ? -1L : L;
    }

    public static String getCurrentTraceIdString() {
        String traceId = (String)ThreadTruck.get((Object)"apm.traceid.string");
        if (traceId == null) {
            return "";
        }
        return traceId;
    }

    public static String idToHex(long id) {
        char[] data = new char[16];
        TraceIdUtil.writeHexLong(data, 0, id);
        String s = new String(data);
        while (s.startsWith("0")) {
            s = s.substring(1);
        }
        return s;
    }

    public static long hexToId(String hexString) {
        int length = hexString.length();
        if (length < 1 || length > 32) {
            throw new IllegalArgumentException("Malformed id: " + hexString);
        }
        int beginIndex = length > 16 ? length - 16 : 0;
        return TraceIdUtil.hexToId(hexString, beginIndex);
    }

    public static long hexToId(String lowerHex, int index) {
        long result = 0L;
        int endIndex = Math.min(index + 16, lowerHex.length());
        while (index < endIndex) {
            char c = lowerHex.charAt(index);
            result <<= 4;
            if (c >= '0' && c <= '9') {
                result |= (long)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                result |= (long)(c - 97 + 10);
            } else {
                throw new IllegalArgumentException("Malformed id: " + lowerHex);
            }
            ++index;
        }
        return result;
    }

    static void writeHexLong(char[] data, int pos, long v) {
        TraceIdUtil.writeHexByte(data, pos + 0, (byte)(v >>> 56 & 0xFFL));
        TraceIdUtil.writeHexByte(data, pos + 2, (byte)(v >>> 48 & 0xFFL));
        TraceIdUtil.writeHexByte(data, pos + 4, (byte)(v >>> 40 & 0xFFL));
        TraceIdUtil.writeHexByte(data, pos + 6, (byte)(v >>> 32 & 0xFFL));
        TraceIdUtil.writeHexByte(data, pos + 8, (byte)(v >>> 24 & 0xFFL));
        TraceIdUtil.writeHexByte(data, pos + 10, (byte)(v >>> 16 & 0xFFL));
        TraceIdUtil.writeHexByte(data, pos + 12, (byte)(v >>> 8 & 0xFFL));
        TraceIdUtil.writeHexByte(data, pos + 14, (byte)(v & 0xFFL));
    }

    static void writeHexByte(char[] data, int pos, byte b) {
        data[pos + 0] = HEX_DIGITS[b >> 4 & 0xF];
        data[pos + 1] = HEX_DIGITS[b & 0xF];
    }
}

