/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter;

import java.io.Serializable;
import kd.bos.context.RequestContext;
import kd.bos.limiter.scene.ConcurrentInstance;
import kd.bos.limiter.scene.ConcurrentScene;
import kd.bos.limiter.scene.ConcurrentSceneManager;
import kd.bos.util.StringUtils;

public abstract class AbstractLimiter
implements AutoCloseable,
Serializable {
    public static final String KEY_SUFFIX = "RATE_LIMITER_";
    public static final String DELIMITER = "_";
    public static final String COLON = ":";
    protected ConcurrentScene scene;
    protected String sceneCode;
    protected String bizCode;
    public String storeKey;
    public String uniqueID;
    protected String tenantID;
    protected boolean isHeartbeat = false;

    protected abstract boolean allow();

    public abstract void release();

    @Override
    public void close() throws Exception {
        this.release();
    }

    public static String getStoreKey(String sceneCode, String bizCode) {
        if (StringUtils.isEmpty((String)sceneCode) || StringUtils.isEmpty((String)bizCode)) {
            return null;
        }
        ConcurrentScene scene = ConcurrentSceneManager.getScene(sceneCode);
        if (scene == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(KEY_SUFFIX);
        stringBuilder.append(sceneCode);
        stringBuilder.append(DELIMITER);
        stringBuilder.append(bizCode);
        if (scene.isTenantIsolation()) {
            RequestContext context = RequestContext.get();
            if (context == null || StringUtils.isEmpty((String)context.getTenantId())) {
                return null;
            }
            stringBuilder.append(DELIMITER);
            stringBuilder.append(context.getTenantId());
        }
        return stringBuilder.toString();
    }

    public String getConcurrentID() {
        if (this.scene == null) {
            return null;
        }
        String sceneCode = this.scene.getSceneCode();
        StringBuilder builder = new StringBuilder();
        if (this.scene.isTenantIsolation()) {
            builder.append("4");
        } else {
            builder.append("3");
        }
        builder.append(sceneCode.length());
        builder.append(COLON);
        builder.append(sceneCode);
        builder.append(DELIMITER);
        builder.append(this.bizCode.length());
        builder.append(COLON);
        builder.append(this.bizCode);
        builder.append(DELIMITER);
        if (this.scene.isTenantIsolation()) {
            builder.append(this.tenantID.length());
            builder.append(COLON);
            builder.append(this.tenantID);
            builder.append(DELIMITER);
        }
        builder.append(this.uniqueID.length());
        builder.append(COLON);
        builder.append(this.uniqueID);
        return builder.toString();
    }

    public static ConcurrentInstance decode(String concurrentID) throws Exception {
        if (StringUtils.isEmpty((String)concurrentID) || concurrentID.indexOf(COLON) <= 0) {
            return null;
        }
        ConcurrentInstance concurrentInstance = new ConcurrentInstance();
        int count = Integer.parseInt(concurrentID.substring(0, 1));
        int startIndex = 1;
        int endIndex = concurrentID.indexOf(COLON);
        int len = Integer.parseInt(concurrentID.substring(startIndex, endIndex));
        startIndex = endIndex + 1;
        endIndex = startIndex + len;
        String sceneCode = concurrentID.substring(startIndex, endIndex);
        concurrentInstance.setSceneCode(sceneCode);
        startIndex = endIndex + 1;
        endIndex = concurrentID.indexOf(COLON, startIndex);
        len = Integer.parseInt(concurrentID.substring(startIndex, endIndex));
        startIndex = endIndex + 1;
        endIndex = startIndex + len;
        String bizCode = concurrentID.substring(startIndex, endIndex);
        concurrentInstance.setBizCode(bizCode);
        if (count == 4) {
            startIndex = endIndex + 1;
            endIndex = concurrentID.indexOf(COLON, startIndex);
            len = Integer.parseInt(concurrentID.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
            endIndex = startIndex + len;
            String tenantID = concurrentID.substring(startIndex, endIndex);
            concurrentInstance.setTenantID(tenantID);
        }
        startIndex = endIndex + 1;
        endIndex = concurrentID.indexOf(COLON, startIndex);
        len = Integer.parseInt(concurrentID.substring(startIndex, endIndex));
        startIndex = endIndex + 1;
        endIndex = startIndex + len;
        String uniqueID = concurrentID.substring(startIndex, endIndex);
        concurrentInstance.setUniqueID(uniqueID);
        return concurrentInstance;
    }

    public static String getCurrUserID() {
        RequestContext context = RequestContext.get();
        if (context == null) {
            return "-101101";
        }
        return Long.toString(context.getCurrUserId());
    }

    public boolean isHeartbeat() {
        return this.isHeartbeat;
    }

    public void setHeartbeat(boolean heartbeat) {
        this.isHeartbeat = heartbeat;
    }
}

