/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.limiter.algorithm.NaturalTimeCluster;
import kd.bos.util.StringUtils;

public class GatewayLimiter {
    public static final Map<String, NaturalTimeCluster> NATURAL_TIME_CLUSTER_MAP = new ConcurrentHashMap<String, NaturalTimeCluster>();

    public static boolean isAllowed() {
        String tenantId = RequestContext.get().getTenantId();
        if (StringUtils.isEmpty((String)tenantId)) {
            return true;
        }
        NATURAL_TIME_CLUSTER_MAP.computeIfAbsent(tenantId, k -> new NaturalTimeCluster(tenantId));
        NaturalTimeCluster naturalTimeCluster = NATURAL_TIME_CLUSTER_MAP.get(tenantId);
        return naturalTimeCluster.allowRequest();
    }
}

