/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.limiter.algorithm.Counter;
import kd.bos.limiter.algorithm.FixedWindowCluster;
import kd.bos.limiter.algorithm.FixedWindowNode;
import kd.bos.limiter.algorithm.FixedWindowThread;
import kd.bos.limiter.algorithm.RequestsCleaner;
import kd.bos.limiter.algorithm.SlidingWindowCluster;
import kd.bos.limiter.algorithm.SlidingWindowNode;
import kd.bos.limiter.algorithm.SlidingWindowThread;
import kd.bos.limiter.constant.Algorithm;
import kd.bos.limiter.constant.Range;
import kd.bos.limiter.scene.Scene;
import kd.bos.limiter.scene.SceneManager;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.LimiterUtil;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Limiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Limiter.class);
    private static final Map<String, Counter> COUNTER_MAP = new ConcurrentHashMap<String, Counter>();
    private static final Map<String, FixedWindowNode> FIXED_WINDOW_NODE_MAP = new ConcurrentHashMap<String, FixedWindowNode>();
    public static final Map<String, SlidingWindowNode> SLIDING_WINDOW_NODE_MAP = new ConcurrentHashMap<String, SlidingWindowNode>();
    private static final Map<String, FixedWindowThread> FIXED_WINDOW_THREAD_MAP = new ConcurrentHashMap<String, FixedWindowThread>();
    private static final Map<String, SlidingWindowThread> SLIDING_WINDOW_THREAD_MAP = new ConcurrentHashMap<String, SlidingWindowThread>();
    public static final Map<String, FixedWindowCluster> FIXED_WINDOW_CLUSTER_MAP = new ConcurrentHashMap<String, FixedWindowCluster>();
    public static final Map<String, SlidingWindowCluster> SLIDING_WINDOW_CLUSTER_MAP = new ConcurrentHashMap<String, SlidingWindowCluster>();
    public static final String REDIS_LIMIT_REGION = "rate_limiter";

    public static void checkAndRecord(String sceneCode) {
        try {
            String accountId = RequestContext.get().getAccountId();
            if (!LimiterUtil.isSystemBootFinish() || StringUtils.isEmpty((String)accountId)) {
                return;
            }
            Scene scene = SceneManager.getScene(sceneCode);
            if (scene != null && scene.isLimitEnable()) {
                Range range;
                String key = accountId + "_" + sceneCode;
                if (scene.getAlgorithm() == Algorithm.COUNTER) {
                    if (!Limiter.isWebRpc()) {
                        return;
                    }
                    if (scene.getRange() == Range.THREAD) {
                        COUNTER_MAP.computeIfAbsent(key, k -> new Counter(scene));
                        Counter counter = COUNTER_MAP.get(key);
                        counter.allowRequest();
                    }
                }
                if (scene.getAlgorithm() == Algorithm.FIXED_WINDOW) {
                    range = scene.getRange();
                    if (range == Range.NODE && !StringUtils.isEmpty((String)accountId)) {
                        FIXED_WINDOW_NODE_MAP.computeIfAbsent(key, k -> new FixedWindowNode(scene));
                        FixedWindowNode fixedWindow = FIXED_WINDOW_NODE_MAP.get(key);
                        fixedWindow.allowRequest();
                    }
                    if (range == Range.THREAD) {
                        FIXED_WINDOW_THREAD_MAP.computeIfAbsent(key, k -> new FixedWindowThread(scene));
                        FixedWindowThread fixedWindowThread = FIXED_WINDOW_THREAD_MAP.get(key);
                        fixedWindowThread.allowRequest();
                    }
                    if (range == Range.CLUSTER) {
                        FIXED_WINDOW_CLUSTER_MAP.computeIfAbsent(key, k -> new FixedWindowCluster(scene, accountId));
                        FixedWindowCluster fixedWindowCluster = FIXED_WINDOW_CLUSTER_MAP.get(key);
                        fixedWindowCluster.allowRequest();
                    }
                }
                if (scene.getAlgorithm() == Algorithm.SLIDING_WINDOW) {
                    range = scene.getRange();
                    if (range == Range.NODE && !StringUtils.isEmpty((String)accountId)) {
                        SLIDING_WINDOW_NODE_MAP.computeIfAbsent(key, k -> new SlidingWindowNode(scene));
                        SlidingWindowNode slidingWindowNode = SLIDING_WINDOW_NODE_MAP.get(key);
                        slidingWindowNode.allowRequest();
                        RequestsCleaner.start();
                    }
                    if (range == Range.THREAD) {
                        SLIDING_WINDOW_THREAD_MAP.computeIfAbsent(key, k -> new SlidingWindowThread(scene));
                        SlidingWindowThread slidingWindowThread = SLIDING_WINDOW_THREAD_MAP.get(key);
                        slidingWindowThread.allowRequest();
                    }
                    if (range == Range.CLUSTER) {
                        SLIDING_WINDOW_CLUSTER_MAP.computeIfAbsent(key, k -> new SlidingWindowCluster(scene, accountId));
                        SlidingWindowCluster slidingWindowCluster = SLIDING_WINDOW_CLUSTER_MAP.get(key);
                        slidingWindowCluster.allowRequest();
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof KDException && ((KDException)e).getErrorCode() == BosErrorCode.limitOverMaxCount) {
                throw e;
            }
            LOGGER.error("Limiter check and record ERROR. ", (Throwable)e);
        }
    }

    private static boolean isWebRpc() {
        Object objWebRpc = ThreadTruck.get((Object)"limiter.is_web_rpc");
        if (objWebRpc == null) {
            return false;
        }
        try {
            boolean isWebRpc = (Boolean)objWebRpc;
            if (isWebRpc) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static Map<String, SlidingWindowNode> getSlidingWindowNodeMap() {
        return SLIDING_WINDOW_NODE_MAP;
    }
}

