/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.algorithm;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.LimitEvent;
import kd.bos.limiter.scene.Scene;
import kd.bos.limiter.scheduler.FixedWindowScheduler;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;

public class FixedWindowCluster {
    private final Scene scene;
    private final long windowTime;
    public static final String REDIS_KEY_PREFIX = "LIMITER_FIXED_WINDOW_";
    public final String redisKey;
    public AtomicLong tempCounter = new AtomicLong(0L);
    public TimeUnit AsyncWindowTime;

    public FixedWindowCluster(Scene scene, String accountId) {
        this.scene = scene;
        this.redisKey = REDIS_KEY_PREFIX + accountId + "_" + scene.getCode();
        this.windowTime = TimeUnit.SECONDS.convert(scene.getWindowTime(), scene.getWindowTimeUnit());
    }

    public void allowRequest() {
        if (this.scene.isAsync()) {
            String keySuffix = this.getKeySuffix();
            if (keySuffix != null) {
                String counter;
                try (JedisClient jedis = FixedWindowCluster.getJedisClient();){
                    counter = jedis.get(this.getAsyncKey());
                }
                if (counter != null && Long.parseLong(counter) > this.scene.getMaxCount()) {
                    String msg = "Operate was terminated by Limiter. code: " + this.scene.getName() + " maxCount: " + counter;
                    EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
                    throw new KDException(BosErrorCode.limitOverMaxCount, new Object[]{msg});
                }
                FixedWindowScheduler.getInstance();
                this.tempCounter.incrementAndGet();
            }
        } else {
            long current;
            String luaScript = "local current current = redis.call('incrby',KEYS[1],ARGV[1]) if tonumber(current) == 1 then redis.call('expire',KEYS[1],ARGV[2]) end return current";
            String increment = "1";
            try (JedisClient jedis = FixedWindowCluster.getJedisClient();){
                current = (Long)jedis.eval(luaScript, 1, new String[]{this.redisKey, increment, Long.toString(this.windowTime)});
            }
            if (current >= this.scene.getMaxCount()) {
                String msg = "Operate was terminated by Limiter. code: " + this.scene.getName() + " maxCount: " + current;
                EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
                throw new KDException(BosErrorCode.limitOverMaxCount, new Object[]{msg});
            }
        }
    }

    public static JedisClient getJedisClient() {
        String configKey = CacheConfigKeys.getSessionlessConfigKey((String)"rate_limiter");
        String url = System.getProperty(configKey);
        if (url == null) {
            configKey = CacheConfigKeys.getSessionlessConfigKey(null);
            url = System.getProperty(configKey);
        }
        return RedisFactory.getJedisClient((String)url);
    }

    private String getKeySuffix() {
        LocalDateTime now = LocalDateTime.now();
        switch ((int)this.windowTime) {
            case 60: {
                this.AsyncWindowTime = TimeUnit.MINUTES;
                return now.format(DateTimeFormatter.ofPattern("yyyyMMddHHmm"));
            }
            case 3600: {
                this.AsyncWindowTime = TimeUnit.HOURS;
                return now.format(DateTimeFormatter.ofPattern("yyyyMMddHH"));
            }
            case 86400: {
                this.AsyncWindowTime = TimeUnit.DAYS;
                return now.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            }
        }
        return null;
    }

    public String getAsyncKey() {
        return this.redisKey + "_" + this.getKeySuffix();
    }

    public boolean getIsAsync() {
        return this.scene.isAsync();
    }
}

