/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.algorithm;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.LimitEvent;
import kd.bos.limiter.scene.Scene;
import kd.bos.util.StringUtils;

public class FixedWindowNode {
    public static final int STACK_LEVEL_INDEX = 4;
    private int counter;
    private final Lock lock = new ReentrantLock();
    private final Scene scene;
    private long timestamp;
    private final long windowTime;

    public FixedWindowNode(Scene scene) {
        this.scene = scene;
        this.timestamp = System.currentTimeMillis();
        this.windowTime = TimeUnit.MILLISECONDS.convert(scene.getWindowTime(), scene.getWindowTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allowRequest() {
        if (this.isIncludePackEnable() && this.isExcludePackEnable()) {
            this.lock.lock();
            try {
                long now = System.currentTimeMillis();
                if (now - this.timestamp < this.windowTime) {
                    if ((long)this.counter < this.scene.getMaxCount()) {
                        ++this.counter;
                        return;
                    }
                    String msg = "Operate was terminated by Limiter. code: " + this.scene.getName() + " maxCount: " + this.counter;
                    EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
                    throw new KDException(BosErrorCode.limitOverMaxCount, new Object[]{msg});
                }
                this.counter = 1;
                this.timestamp = now;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private boolean isIncludePackEnable() {
        boolean ret = false;
        if (StringUtils.isEmpty((String)this.scene.getIncludePackage())) {
            return true;
        }
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        if (stackTraceElements.length > 4) {
            String className = stackTraceElements[4].getClassName();
            List<String> includePackages = this.scene.getIncludePackages();
            if (includePackages != null && includePackages.size() > 0) {
                for (String pack : includePackages) {
                    if (!className.contains(pack)) continue;
                    ret = true;
                    break;
                }
            }
        }
        return ret;
    }

    private boolean isExcludePackEnable() {
        boolean ret = true;
        if (StringUtils.isEmpty((String)this.scene.getExcludePackage())) {
            return true;
        }
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        if (stackTraceElements.length > 4) {
            String className = stackTraceElements[4].getClassName();
            List<String> excludePackages = this.scene.getExcludePackages();
            if (excludePackages != null && excludePackages.size() > 0) {
                for (String pack : excludePackages) {
                    if (!className.contains(pack)) continue;
                    ret = false;
                    break;
                }
            }
        }
        return ret;
    }
}

