/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.algorithm;

import java.util.concurrent.TimeUnit;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.LimitEvent;
import kd.bos.limiter.algorithm.ThreadCount;
import kd.bos.limiter.scene.Scene;
import kd.bos.thread.ThreadTruck;

public class FixedWindowThread
extends ThreadCount {
    private final long windowTime;
    private static final String PREFIX_TIMESTAMP = "LIMITER_TIMESTAMP_";
    private String threadTimestampKey;

    public FixedWindowThread(Scene scene) {
        super(scene);
        this.windowTime = TimeUnit.MILLISECONDS.convert(scene.getWindowTime(), scene.getWindowTimeUnit());
        this.threadTimestampKey = PREFIX_TIMESTAMP + scene.getCode();
    }

    @Override
    public void check() {
        long now = System.currentTimeMillis();
        long counter = (Long)this.getCountInThread();
        if (now - this.getTimestamp(now) < this.windowTime) {
            if (counter < this.scene.getMaxCount()) {
                this.setCountIntoThread(counter + 1L);
                return;
            }
            String msg = "Operate was terminated by Limiter. code: " + this.scene.getName() + " maxCount: " + counter;
            EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
            throw new KDException(BosErrorCode.limitOverMaxCount, new Object[]{msg});
        }
        this.setCountIntoThread(1L);
        this.setTimestamp(now);
    }

    private long getTimestamp(long now) {
        Object timestamp = ThreadTruck.get((Object)this.threadTimestampKey);
        if (timestamp == null) {
            return now;
        }
        return (Long)timestamp;
    }

    private void setTimestamp(long timestamp) {
        ThreadTruck.put((Object)this.threadTimestampKey, (Object)timestamp);
    }
}

