/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.limiter.algorithm;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.limiter.scheduler.NaturalTimeScheduler;

public class NaturalTimeCluster {
    public static final String REDIS_KEY_PREFIX = "LIMITER_NATURAL_TIME_";
    public static final String TENANT_MAX_COUNT_SUFFIX = "limiter.apiGateway.maxCount";
    public AtomicLong tempCounter = new AtomicLong(0L);
    public volatile int currentCounter;
    private final String tenantId;
    private final String tenantMaxCountKey;

    public NaturalTimeCluster(String tenantId) {
        this.tenantId = tenantId;
        this.tenantMaxCountKey = tenantId + "_" + TENANT_MAX_COUNT_SUFFIX;
    }

    public boolean allowRequest() {
        int maxCount = this.getMaxCount();
        if (maxCount <= 0) {
            return true;
        }
        if (this.currentCounter > maxCount) {
            return false;
        }
        NaturalTimeScheduler.getInstance();
        this.tempCounter.incrementAndGet();
        return true;
    }

    private int getMaxCount() {
        Integer tenantMaxCount = Integer.getInteger(this.tenantMaxCountKey);
        if (tenantMaxCount != null) {
            return tenantMaxCount;
        }
        Integer globalMaxCount = Integer.getInteger(TENANT_MAX_COUNT_SUFFIX);
        if (globalMaxCount != null) {
            return globalMaxCount;
        }
        return -1;
    }

    public String getRedisKey() {
        return REDIS_KEY_PREFIX + this.tenantId + "_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }
}

